/*
 * Original code written by TrueBrain
 * Zuu has added the twist that cargo requirement depend on the size
 * of nearby towns.
 *
 * I (Zuu) have been granted the rights of TrueBrain to release his original
 * code.
 *
 * License: GPL2
 */

require("version.nut");

class MainClass extends GSInfo {
	function GetAuthor()		{ return "Zuu"; }
	function GetName()			{ return "Neighbours are important"; }
	function GetDescription() 	{ return "Towns require cargo to grow. Larger towns require more cargo to grow additionally. As an extra excitement, the size of the neighbour towns have an impact on how much cargo is required for a town to grow. If there are nearby towns that are larger than a town itself, that reduces the cargo requirement. Also watch out for the congestion in your towns."; }
	function GetVersion()		{ return SELF_VERSION; }
	function GetDate()			{ return "2012-10-27"; }
	function CreateInstance()	{ return "MainClass"; }
	function GetShortName()		{ return "NGBR"; }
	function GetAPIVersion()	{ return "1.2"; }
	function GetUrl()			{ return ""; }
	function GetSettings() {
		AddSetting({name = "enable_neighbours",
				description = "Cargo requirement depends on",
				easy_value = 1,
				medium_value = 1,
				hard_value = 1,
				custom_value = 1,
				flags = CONFIG_INGAME, min_value = 0, max_value = 1});
		AddLabels("enable_neighbours", {_0 = "size of current town size", _1 = "both size of current town and its neighbours" } );

		AddSetting({name = "goal_scale_factor",
				description = "Cargo goal factor (in %) [easy = 50, medium = 100, hard = 150]",
				easy_value = 50,
				medium_value = 100,
				hard_value = 150,
				custom_value = 100,
				flags = CONFIG_INGAME, min_value = 1, max_value = 1000});

		// constants for congestion_policy are defined in version.nut
		AddSetting({name = "congestion_policy",
				description = "Congested towns",
				easy_value = 2,
				medium_value = 2,
				hard_value = 3,
				custom_value = 2,
				flags = CONFIG_INGAME, min_value = 1, max_value = 3});
		AddLabels("congestion_policy", {_1 = "Doesn't care about congestion [disabled]", _2 = "Grows slower", _3 = "No growth" } );

		AddSetting({name = "congestion_limit_factor",
				description = "Congestion limit factor (in %) [easy = 150, medium = 100, hard = 50]",
				easy_value = 50,
				medium_value = 100,
				hard_value = 150,
				custom_value = 100,
				flags = CONFIG_INGAME, min_value = 1, max_value = 1000});

		AddSetting({name = "log_level", 
				description = "Debug: Log level (higher = print more)", 
				easy_value = 1,
				medium_value = 1,
				hard_value = 1,
				custom_value = 1,
				flags = CONFIG_INGAME, min_value = 1, max_value = 3});
		AddLabels("log_level", {_1 = "1: Info", _2 = "2: Verbose", _3 = "3: Debug" } );
	}

}

RegisterGS(MainClass());
