require("version.nut");
require("town.nut");

/* Import SuperLib for GameScript */
import("util.superlib", "SuperLib", 26);
Result <- SuperLib.Result;
Log <- SuperLib.Log;
Helper <- SuperLib.Helper;
ScoreList <- SuperLib.ScoreList;
Tile <- SuperLib.Tile;
Direction <- SuperLib.Direction;
Town <- SuperLib.Town;
Industry <- SuperLib.Industry;

class MainClass extends GSController 
{
	constructor()
	{
	}

	towns = null;
	last_date = 0;
	current_year = 0;
}

function MainClass::Start()
{
	local start_tick = GSController.GetTick();
	this.Init();
	local setup_duration = GSController.GetTick() - start_tick;

	Log.Info("Game setup done", Log.LVL_INFO);
	Log.Info("Setup took " + setup_duration + " ticks", Log.LVL_INFO);
	Log.Info("", Log.LVL_INFO);

	Log.Info("Happy playing", Log.LVL_INFO);

	GSController.Sleep(1);

	while (true) {
		this.HandleEvents();
		this.ManageTowns();

		this.Sleep(60);
	}
}

function MainClass::Init()
{
	GSGameSettings.SetValue("economy.town_growth_rate", 2);
	GSGameSettings.SetValue("economy.fund_buildings", 0);
	this.last_date = GSDate.GetCurrentDate();
	this.current_year = GSDate.GetYear(this.last_date);

	// Create the towns list
	Log.Info("Create town list ... (can take a while on large maps)", Log.LVL_INFO);
	this.towns = this.CreateTownList();

	// Set initial time the towns will grow
	InitalizeManageTimers(this.towns);
}

// Non-class function
function InitalizeManageTimers(town_list)
{
	foreach (town in town_list) {
		town.check_timer = GSBase.RandRange(20) + 10;
		town.ManageTown();
	}
}

function MainClass::HandleEvents()
{
	if (GSEventController.IsEventWaiting())
	{
		local ev = GSEventController.GetNextEvent();

		if (ev == null)
			return;

		// check event type
		// handle event
	}
}

function MainClass::CreateTownList()
{
	local result = [];

	/* Make a squirrel array of all towns.
	 * For each town, an instance of GoalTown is created
	 * to store the data related to that town
	 */
	local all_towns = GSTownList();
	foreach (t, _ in all_towns)
	{
		result.append(GoalTown(t));
	}

	return result;
}

function MainClass::CheckForNewTowns()
{
	// Do our town-list have fewer towns than the game?
	local world_towns = GSTownList();
	if (this.towns.len() < world_towns.Count())
	{
		// Create a GSList with all towns that we have
		local have_towns = GSList();
		foreach (town in this.towns)
		{
			have_towns.AddItem(town.id, 0);
		}
		
		// Reduce the world list of towns with those that we already have
		world_towns.RemoveList(have_towns);

		// Add the remaining towns to our list
		// Also, keep a list of newly added towns
		local new_towns = [];
		foreach (town_id, _ in world_towns)
		{
			local town = GoalTown(town_id);
			this.towns.append(town);
			new_towns.append(town);
		}

		// Perform an initial manage of the new towns
		InitalizeManageTimers(new_towns);
	}
}

function MainClass::ManageTowns()
{
	local date = GSDate.GetCurrentDate();
	local diff = date - this.last_date;
	this.last_date = date;

	if (diff == 0) return;

	foreach (town in this.towns) {

		town.check_timer -= diff;

		if (town.check_timer <= 0) {
			town.check_timer = town.check_timer + GSBase.RandRange(20) + 10;
			town.ManageTown();
		}
	}
}
