
# script_ajaxplorer_desc()
sub script_ajaxplorer_desc
{
return "Pydio";
}

sub script_ajaxplorer_uses
{
return ( "php" );
}

sub script_ajaxplorer_longdesc
{
return "Pydio turns your web server into a powerful file management system";
}

# script_ajaxplorer_versions()
sub script_ajaxplorer_versions
{
return ( "5.2.3" );
}

sub script_ajaxplorer_can_upgrade
{
local ($sinfo, $newver) = @_;
if ($sinfo->{'version'} < 5 && $newver >= 5) {
	return 0;
	}
return 1;
}

# script_ajaxplorer_depends(&domain, version)
sub script_ajaxplorer_depends
{
local ($d, $ver, $sinfo, $phpver) = @_;
local @rv;

# Check for PHP 5.3+
local $phpv = &get_php_version($phpver || 5, $d);
if (!$phpv) {
	push(@rv, "Could not work out exact PHP version");
	}
elsif ($phpv < 5.2) {
	push(@rv, "Pydio requires PHP version 5.3 or later");
	}

return @rv;
}

sub script_ajaxplorer_php_vers
{
local ($d, $ver) = @_;
return ( 5 );
}

sub script_ajaxplorer_php_modules
{
return ( "xml", "gd", "zip" );
}

sub script_ajaxplorer_php_vars
{
return ( [ 'output_buffering', 'off' ] );
}

sub script_ajaxplorer_depends
{
local ($d, $ver) = @_;
local @rv;
local $mode = &get_domain_php_mode($d);
$mode eq "mod_php" &&
	push(@rv, "Pydio requires that PHP scripts be executed with fcgid or cgi modes, so that they can modify your files");
return @rv;
}

# script_ajaxplorer_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_ajaxplorer_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
		     &ui_opt_textbox("dir", &substitute_scriptname_template("pydio", $d), 30, "At top level"));
	}
return $rv;
}

# script_ajaxplorer_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_ajaxplorer_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	return { 'dir' => $dir,
		 'path' => "/$in{'dir'}", };
	}
}

# script_ajaxplorer_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_ajaxplorer_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/conf/bootstrap_conf.php") {
	return "Pydio appears to be already installed in the selected directory";
	}
return undef;
}

# script_ajaxplorer_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Twiki, each of which is a hash ref
# containing a name, filename and URL
sub script_ajaxplorer_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "pydio-core-$ver.tar.gz",
	   'url' => "https://downloads.sourceforge.net/project/ajaxplorer/pydio/stable-channel/$ver/pydio-core-$ver.tar.gz" } );
return @files;
}

sub script_ajaxplorer_commands
{
return ("unzip");
}

# script_ajaxplorer_install(&domain, version, &opts, &files, &upgrade-info,
# 			   [user, pass])
# Actually installs PhpWiki, and returns either 1 and an informational
# message, or 0 and an error
sub script_ajaxplorer_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);

# Preserve old config file
local $cfile = "$opts->{'dir'}/conf/bootstrap_context.php";
local $oldcfile = &transname();
if ($upgrade) {
	&copy_source_dest($cfile, $oldcfile);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "pydio-core-*");
$err && return (0, "Failed to extract source : $err");

local $url = &script_path_url($d, $opts);
if ($upgrade) {
	# Put back original config file
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	}
else {
	# Edit the config file
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	local $donelocale = 0;
	foreach my $l (@$lref) {
		if ($l =~ /define\("(INITIAL_ADMIN_PASSWORD|ADMIN_PASSWORD)", "admin"\);/) {
			$l = "define(\"$1\", \"$dompass\");";
			}
		elsif ($l =~ /define\("AJXP_LOCALE",/ && !$donelocale++) {
			$l = "define(\"AJXP_LOCALE\", \"en_US.UTF-8\");";
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);

	# Edit the default repositories file
	local $rfile = "$opts->{'dir'}/conf/bootstrap_repositories.php";
	local $lref = &read_file_lines_as_domain_user($d, $rfile);
	local $ht = &public_html_dir($d);
	foreach my $l (@$lref) {
		if ($l =~ /"AJXP_DATA_PATH\/files"/) {
			$l =~ s/"AJXP_DATA_PATH\/files"/"$ht"/;
			}
		}
	&flush_file_lines_as_domain_user($d, $rfile);
	}

local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Initial Pydio installation complete. Got to <a href='$url' target=_blank>$url</a> to complete the installation process", "Under $rp", $url);
}

# script_ajaxplorer_uninstall(&domain, version, &opts)
# Un-installs an Pydio installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_ajaxplorer_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

return (1, "Pydio directory deleted.");
}

# script_ajaxplorer_check_latest()
sub script_ajaxplorer_check_latest
{
local ($ver) = @_;
local @vers = &osdn_package_versions("ajaxplorer/pydio/stable-channel",
				     "pydio-core-([0-9\\.]+)\\.tar\\.gz");
return "Failed to find versions" if (!@vers);
return $ver eq $vers[0] ? undef : $vers[0];
}

sub script_ajaxplorer_site
{
return "http://pyd.io/";
}

1;

