
# script_b2evolution_desc()
sub script_b2evolution_desc
{
return "b2evolution";
}

sub script_b2evolution_uses
{
return ( "php" );
}

sub script_b2evolution_longdesc
{
return "A multilingual multiuser multi-blog engine.";
}

# script_b2evolution_versions()
sub script_b2evolution_versions
{
return ( "4.1.6-stable-2012-11-23", "1.9.2-2007-01-22" );
}

sub script_b2evolution_version_desc
{
local ($ver) = @_;
$ver =~ s/\-(\d+)\-(\d+)\-(\d+)$//;
return $ver;
}

sub script_b2evolution_category
{
return "Blog";
}

sub script_b2evolution_php_vers
{
return ( 4, 5 );
}

sub script_b2evolution_php_modules
{
return ("mysql");
}

sub script_b2evolution_perl_modules
{
return ( "Digest::MD5" );
}

sub script_b2evolution_dbs
{
return ("mysql");
}

# script_b2evolution_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing b2evolution
sub script_b2evolution_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for b2evolution tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for b2evolution tables",
		     &ui_database_select("db", undef, \@dbs, $d,"b2evolution"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("b2evolution", $d), 30, "At top level"));
	}
return $rv;
}

# script_b2evolution_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_b2evolution_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_b2evolution_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_b2evolution_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/conf/_config.php") {
	return "b2evolution appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "evo_.*");
$clash && return "b2evolution appears to be already using the selected database (table $clash)";
return undef;
}

# script_b2evolution_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by b2evolution, each of which is a hash ref
# containing a name, filename and URL
sub script_b2evolution_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "b2evolution-$ver.zip",
	   'url' => "http://osdn.dl.sourceforge.net/sourceforge/evocms/b2evolution-$ver.zip" } );
return @files;
}

sub script_b2evolution_commands
{
return ("unzip");
}

# script_b2evolution_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs b2evolution, and returns either 1 and an informational
# message, or 0 and an error
sub script_b2evolution_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Preserve old config file
local $cfile = "$opts->{'dir'}/conf/_config.php";
local $oldcfile = &transname();
if ($upgrade) {
	&copy_source_dest($cfle, $oldcfile);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "b2evolution/blogs");
$err && return (0, "Failed to extract source : $err");

local $url = &script_path_url($d, $opts);
if ($upgrade) {
	# Put back original config file
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	}
else {
	# Make config files writable
	&make_file_php_writable($d, $cfile);
	&make_file_php_writable($d, "$opts->{'dir'}/conf/_basic_config.php");

	# Trigger the installation PHP script
	local @params = (
		[ "conf_db_user", $dbuser ],
		[ "conf_db_password", $dbpass ],
		[ "conf_db_name", $dbname ],
		[ "conf_db_host", $dbhost ],
		[ "conf_db_tableprefix", "evo_" ],
		[ "conf_baseurl", $url ],
		[ "conf_admin_email", $d->{'emailto_addr'} ],
		[ "action", "conf" ],
		[ "locale", "en-EU" ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install/index.php";

	# Make an HTTP post to the installer page
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "b2evolution post-install configuration failed : $ierror");
		}

	# Trigger the DB setup PHP script
	local $ipage = $opts->{'path'}."/install/index.php";
	local $params = "action=newdb";
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "b2evolution DB setup failed : $ierror");
		}

	# Set the admin user and password
	&require_mysql();
	local $md5;
	eval "use Digest::MD5";
	if (!$@) {
		$md5 = Digest::MD5::md5_hex($dompass);
		}
	eval {
		local $main::error_must_die = 1;
		&mysql::execute_sql($dbname, "update evo_users set user_login = ?, user_pass = ? where user_login = 'admin'", $domuser, $md5);
		};
	if ($@) {
		return (-1, "Admin user update failed : $@");
		}
	}

# Return a URL for the user
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "b2evolution installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.", "Under $rp using $dbphptype database $dbname", $url, $domuser, $dompass);
}

# script_b2evolution_uninstall(&domain, version, &opts)
# Un-installs a b2evolution installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_b2evolution_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all evo_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "evo_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "b2evolution directory and tables deleted.");
}

sub script_b2evolution_site
{
return 'http://b2evolution.net/';
}

sub script_b2evolution_passmode
{
return 1;
}

1;

