
# script_bbpress_desc()
sub script_bbpress_desc
{
return "bbPress";
}

sub script_bbpress_uses
{
return ( "php" );
}

sub script_bbpress_longdesc
{
return "bbPress is forum software with a twist from the creators of WordPress.";
}

# script_bbpress_versions()
sub script_bbpress_versions
{
return ( "1.2" );
}

sub script_bbpress_can_upgrade
{
local ($sinfo, $newver) = @_;
if ($sinfo->{'version'} < 0.9 && $newver >= 0.9) {
	return 0;
	}
return 1;
}

sub script_bbpress_category
{
return "Community";
}

sub script_bbpress_php_vers
{
return ( 5 );
}

sub script_bbpress_php_modules
{
return ("mysql");
}

sub script_bbpress_dbs
{
return ("mysql");
}

# script_bbpress_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_bbpress_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for bbPress tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for bbPress tables",
		     &ui_database_select("db", undef, \@dbs, $d, "bbpress"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("bbpress", $d), 30, "At top level"));
	}
return $rv;
}

# script_bbpress_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_bbpress_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_bbpress_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_bbpress_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/bb-config.php") {
	return "bbPress appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "wp_.*");
$clash && return "bbPress appears to be already using the selected database (table $clash)";
return undef;
}

# script_bbpress_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_bbpress_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "bbpress-$ver.zip",
	   'url' => "http://bbpress.trac.wordpress.org/changeset/4522/tags/${ver}?old_path=%2F&format=zip" } );
if ($ver >= 1.2) {
	push(@files, { 'name' => 'backpress',
		       'file' => "backpress-$ver.zip",
		       'url' => "http://backpress.trac.wordpress.org/changeset/354/tags/backpress-${ver}-bbpress?old_path=%2F&format=zip",
		     });
	push(@files, { 'name' => 'pomo',
		       'file' => "pomo-$ver.zip",
		       'url' => "http://scripts.virtualmin.com/pomo.zip",
		     });
	}
return @files;
}

sub script_bbpress_commands
{
return ("unzip");
}

# script_bbpress_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs bbPress, and returns either 1 and an informational
# message, or 0 and an error
sub script_bbpress_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;

# Don't allow upgrades from older version
if ($upgrade && $upgrade->{'version'} < 0.9 && $version >= 0.9) {
	return (0, "Upgrading from versions before 0.9 is not supported");
	}

local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "psql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $verdir = "tags/$ver";
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, $verdir, 0, 1);
$err && return (0, "Failed to extract source : $err");
local $cfileorig = "$opts->{'dir'}/config-sample.php";
local $cfile = "$opts->{'dir'}/config.php";

# Version 1.2 needs some other random files?!
if ($files->{'backpress'}) {
	local $temp2 = &transname();
	local $err = &extract_script_archive($files->{'backpress'}, $temp2, $d,
		     $opts->{'dir'}."/bb-includes/backpress",
		     "tags/backpress-${ver}-bbpress/includes");
	$err && return (0, "Failed to extract backpress : $err");
	}
if ($files->{'pomo'}) {
	local $temp3 = &transname();
	local $err = &extract_script_archive($files->{'pomo'}, $temp3, $d,
		     $opts->{'dir'}."/bb-includes/backpress/pomo", undef);
	$err && return (0, "Failed to extract pomo : $err");
	}

# Copy and update the config file
local $url;
local $userurl = &script_path_url($d, $opts);
local $siteurl = $userurl;
if ($ver < 0.9) {
	$url = &script_path_url($d, $opts)."bb-admin/install.php";
        $siteurl =~ s/\Q$opts->{'path'}\E\/$//;
	}
else {
	$url = $userurl;
	}

if ($ver < 0.9) {
	# Older version uses config file that we create
	if (!-r $cfile) {
		&copy_source_dest_as_domain_user($d, $cfileorig, $cfile);
		local $lref = &read_file_lines_as_domain_user($d, $cfile);
		local $l;
		foreach $l (@$lref) {
			if ($l =~ /^define\('BBDB_NAME',/) {
				$l = "define('BBDB_NAME', '$dbname');";
				}
			if ($l =~ /^define\('BBDB_USER',/) {
				$l = "define('BBDB_USER', '$dbuser');";
				}
			if ($l =~ /^define\('BBDB_HOST',/) {
				$l = "define('BBDB_HOST', '$dbhost');";
				}
			if ($l =~ /^define\('BBDB_PASSWORD',/) {
				$l = "define('BBDB_PASSWORD', '".
				     &php_quotemeta($dbpass)."');";
				}
			if ($l =~ /^\s*\$bb->domain\s*=/) {
				$l = "\$bb->domain = '$siteurl';";
				}
			if ($l =~ /^\s*\$bb->path\s*=/) {
				$l = "\$bb->path = '$opts->{'path'}/';";
				}
			if ($l =~ /^\s*\$bb->admin_email\s*=/) {
				$l = "\$bb->admin_email = '$d->{'emailto_addr'}';";
				}
			}
		&flush_file_lines_as_domain_user($d, $cfile);
		}
	}
elsif (!$upgrade) {
	# New version uses wizard
	local ($iout, $ierror, $nonce);

	# Trigger the DB setup script
	local @params = (
		[ "bbdb_name", $dbname ],
		[ "bbdb_user", $dbuser ],
		[ "bbdb_password", $dbpass ],
		[ "bb_lang", "en_US" ],
		[ "bbdb_host", $dbhost ],
		[ "bbdb_charset", "utf8" ],
		[ "bbdb_collate", "" ],
		[ "bb_secret_key", &random_password(16) ],
		[ "bb_table_prefix", "bb_" ],
		[ "toggle_1", 1 ],
		[ "step", 1 ],
		[ "forward_1_0", "Save database configuration file" ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/bb-admin/install.php?step=1";
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "bbPress database setup failed : $ierror");
		}
	elsif ($iout !~ /Your settings have been saved/i) {
		return (-1, "bbPress database setup failed");
		}

	# Trigger Wordpress integration form
	local $params = "forward_1_2=1&step=2";
	local $ipage = $opts->{'path'}."/bb-admin/install.php?step=2";
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	$nonce = &extract_bbpress_nonce($iout);
	$nonce || return (-1, "Failed to extract nonce from wordpress form");

	# Skip wordpress intrgration
	local @params = (
		[ "_wpnonce", $nonce ],
		[ "_wp_http_referer",
		  $opts->{'path'}."/bb-admin/install.php?step=2" ],
		[ "forward_2_0", "Skip" ],
		[ "step", 2 ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/bb-admin/install.php?step=2";
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	$nonce = &extract_bbpress_nonce($iout);
	$nonce || return (-1, "Failed to extract nonce from wordpress output");

	# Trigger forum setup form
	local @params = (
		[ "_wpnonce", $nonce ],
		[ "_wp_http_referer",
		  $opts->{'path'}."/bb-admin/install.php?step=2" ],
		[ "forward_2_1", "Go" ],
		[ "step", 3 ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/bb-admin/install.php?step=3";
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	$nonce = &extract_bbpress_nonce($iout);
        $nonce || return (-1, "Failed to extract nonce from forum form");

	# Trigger forum creation script
	local @params = (
		[ "_wpnonce", $nonce ],
		[ "_wp_http_referer",
		  $opts->{'path'}."/bb-admin/install.php?step=3" ],
		[ "name", $d->{'owner'} ],
		[ "uri", $url ],
		[ "keymaster_user_login", $domuser ],
		[ "keymaster_user_email", $d->{'emailto_addr'} ],
		[ "keymaster_user_type", "new" ],
		[ "forum_name", $d->{'owner'}." forum" ],
		[ "forward_3_0", "Save" ],
		[ "step", 3 ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/bb-admin/install.php?step=3";
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "bbPress forum setup failed : $ierror");
		}
	elsif ($iout !~ /Your site settings have been saved/i) {
		return (-1, "bbPress forum setup failed");
		}
	$nonce = &extract_bbpress_nonce($iout);
	$nonce || return (-1, "Failed to extract nonce from forum output");

	# Call final step
	@params = grep { $_->[0] ne "_wpnonce" &&
			 $_->[0] ne "_wp_http_referer" &&
		         $_->[0] ne "forward_3_0" } @params;
	push(@params,
		[ "_wpnonce", $nonce ],
		[ "_wp_http_referer",
		  $opts->{'path'}."/bb-admin/install.php?step=3" ],
		[ "forward_3_1", "Complete" ],
		[ "step", 4 ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/bb-admin/install.php?step=4";
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "bbPress site settings failed : $ierror");
		}
	elsif ($iout !~ /Your installation completed successfully/i) {
		return (-1, "bbPress site settings failed");
		}
	if ($iout =~ /Password:\s+([^<]\S+)/i) {
		$dompass = &entities_to_ascii("$1");
		}
	}

# Return a URL for the user
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "bbPress installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.", "Under $rp using $dbphptype database $dbname", $userurl, $domuser, $dompass);
}

# script_bbpress_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_bbpress_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all bb_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "bb_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "bbPress directory and tables deleted.");
}

# script_bbpress_latest()
# Returns a URL and regular expression or callback func to get the version
sub script_bbpress_latest
{
return ( "http://bbpress.org/download/legacy/",
	 "stand-alone<[^>]+>\\s+version\\s+of\\s+bbPress\\s+is\\s+<[^>]+>\\s*([0-9\\.]+)" );
}

sub script_bbpress_site
{
return 'http://bbpress.org/';
}

sub script_bbpress_passmode
{
return 3;
}

sub extract_bbpress_nonce
{
local ($html) = @_;
return $html =~ /name="_wpnonce"\s+value="([^"]+)"/ ? $1 : undef;
}

1;

