
# script_civicspace_desc()
sub script_civicspace_desc
{
return "CivicSpace";
}

sub script_civicspace_uses
{
return ( "php" );
}

sub script_civicspace_longdesc
{
return "CivicSpace is a free open-source software platform for grassroots organizing and civic activity.";
}

# script_civicspace_versions()
sub script_civicspace_versions
{
return ( "0.8.5" );
}

sub script_civicspace_abandoned
{
return 2;
}

sub script_civicspace_category
{
return "Community";
}

sub script_civicspace_php_vers
{
return ( 4, 5 );
}

sub script_civicspace_php_modules
{
return ("mysql");
}

sub script_civicspace_dbs
{
return ("mysql");
}

# script_civicspace_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_civicspace_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for CivicSpace tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for CivicSpace tables",
		     &ui_database_select("db", undef, \@dbs, $d, "civicspace"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("civicspace", $d), 30, "At top level"));
	}
return $rv;
}

# script_civicspace_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_civicspace_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_civicspace_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_civicspace_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/sites/default/settings.php") {
	return "CivicSpace appears to be already installed in the selected directory";
	}
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
$opts->{'db'} || return "Missing database";
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "access");
$clash && return "CivicSpace appears to be already using the selected database (table $clash)";
return undef;
}

# script_civicspace_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by CivicSpace, each of which is a hash ref
# containing a name, filename and URL
sub script_civicspace_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "civicspace-$ver.tar.gz",
	   'url' => "http://download.webmin.com/download/others/civicspace-$ver.tgz" } );
return @files;
}

sub script_civicspace_commands
{
return ("tar", "gunzip");
}

# script_civicspace_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs CivicSpace, and returns either 1 and an informational
# message, or 0 and an error
sub script_civicspace_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbhost = &get_database_host($dbtype);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "psql";
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "civicspace-$ver");
$err && return (0, "Failed to extract source : $err");
local $cfile = "$opts->{'dir'}/sites/default/settings.php";
&run_as_domain_user($d, "cp -p ".quotemeta($temp)."/civicspace-$ver/.htaccess ".
			quotemeta($opts->{'dir'}));

# Update the config file
local $lref = &read_file_lines_as_domain_user($d, $cfile);
local $dburl = "$dbphptype://$dbuser:".&php_quotemeta($dbpass).
	       "\@$dbhost/$dbname";
local $pt = $d->{'web_port'} == 80 ? "" : ":$d->{'web_port'}";
foreach $l (@$lref) {
	if ($l =~ /^\$db_url\s*=/) {
		$l = "\$db_url = '$dburl';"
		}
	if ($l =~ /^\$base_url\s*=/) {
		local $p = $opts->{'path'} eq "/" ? "" : $opts->{'path'};
		$l = "\$base_url = 'http://$d->{'dom'}$pt$p';"
		}
	}
&flush_file_lines_as_domain_user($d, $cfile);

if (!$upgrade) {
	# Run the SQL setup script
	if ($dbtype eq "mysql") {
		local $sqlfile = "$opts->{'dir'}/database/civicspace.mysql";
		&require_mysql();
		($ex, $out) = &mysql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
		$ex && return (0, "Failed to run database setup script : <tt>$out</tt>.");
		}
	elsif ($dbtype eq "postgres") {
		local $sqlfile = "$opts->{'dir'}/database/database.pgsql";
		&require_postgres();
		($ex, $out) = &postgresql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
		$ex && return (0, "Failed to run database setup script in $dbname : <tt>$out</tt>.");
		}
	}

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "CivicSpace installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.", "Under $rp using $dbphptype database $dbname", $url);
}

# script_civicspace_uninstall(&domain, version, &opts)
# Un-installs a CivicSpace installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_civicspace_uninstall
{
local ($d, $version, $opts) = @_;

# Remove civicspace tables from the database, taken from the setup file
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $sqlfile = "$opts->{'dir'}/database/civicspace.".
		 ($dbtype eq "mysql" ? "mysql" : "pgsql");
local @tables;
local $lref = &read_file_lines($sqlfile);
foreach my $l (@$lref) {
	if ($l =~ /^\s*create\s+table\s+(\S+)/i) {
		push(@tables, $1);
		}
	}
&cleanup_script_database($d, $opts->{'db'}, \@tables);

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "CivicSpace directory and tables deleted.");
}

# script_civicspace_latest()
# Returns a URL and regular expression or callback func to get the version
# Disabled as website is broken
#sub script_civicspace_latest
#{
#return ( "http://www.civicspacelabs.org/home/civicspace/features",
#	 "civicspace-([0-9\\.]+).tgz" );
#}

sub script_civicspace_site
{
return 'http://www.civicspacelabs.org/';
}

1;

