
# script_egroupware_desc()
sub script_egroupware_desc
{
return "eGroupWare";
}

sub script_egroupware_uses
{
return ( "php" );
}

sub script_egroupware_longdesc
{
return "EGroupware is a enterprise ready groupware software for your network.";
}

# script_egroupware_versions()
sub script_egroupware_versions
{
return ( "1.8.007.20140512" );
}

sub script_egroupware_release
{
return 2;
}

sub script_egroupware_category
{
return "Calendar";
}

sub script_egroupware_php_vers
{
return ( 5 );
}

sub script_egroupware_pear_modules
{
return ("Auth_SASL", "Net_IMAP", "Net_Sieve",
	"XML_Feed_Parser", "Log");
}

sub script_egroupware_php_modules
{
return ("mysql", "gd", "dom", "imap");
}

sub script_egroupware_dbs
{
return ("mysql");
}

sub script_egroupware_php_vars
{
return ( [ 'safe_mode', 'Off' ],
	 [ 'magic_quotes_runtime', 'Off' ],
	 [ 'register_globals', 'Off' ],
	 [ 'display_errors', 'Off' ],
	 [ 'memory_limit', '24M', '+' ],
	 [ 'max_execution_time', 30, '+' ],
	 [ 'file_uploads', 'On' ],
	 [ 'upload_max_filesize', '8M', '+' ],
	 [ 'post_max_size', '8M', '+' ],
	 [ 'magic_quotes_gpc', 'Off' ],
	 [ 'date.timezone', 'America/Los_Angeles' ],
	);
}

# script_egroupware_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_egroupware_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for eGroupWare tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for eGroupWare tables",
		     &ui_database_select("db", undef, \@dbs, $d, "egroupware"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("egroupware", $d), 30, "At top level"));
	}
return $rv;
}

# script_egroupware_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_egroupware_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_egroupware_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_egroupware_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/header.inc.php") {
	return "eGroupWare appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "egw_.*");
$clash && return "eGroupWare appears to be already using the selected database (table $clash)";
return undef;
}

# script_egroupware_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_egroupware_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = (
	{ 'name' => "source",
	  'file' => "eGroupware-$ver.tar.gz",
	  'url' => "http://superb-west.dl.sourceforge.net/sourceforge/egroupware/eGroupware-$ver.tar.gz" },
	{ 'name' => "pear",
	  'file' => "eGroupware-egw-pear-$ver.tar.gz",
	  'url' => "http://superb-west.dl.sourceforge.net/sourceforge/egroupware/eGroupware-egw-pear-$ver.tar.gz" },
	{ 'name' => 'jpgraph',
	  'file' => 'jpgraph-3.5.0b1.tar.gz',
	  'url' => 'http://jpgraph.net/download/download.php?p=5' },
	);
return @files;
}

sub script_egroupware_commands
{
return ("tar", "gunzip");
}

# script_egroupware_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs eGroupWare, and returns either 1 and an informational
# message, or 0 and an error
sub script_egroupware_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "egroupware");
$err && return (0, "Failed to extract source : $err");

# Extract pear modules
local $temp2 = &transname();
local $err = &extract_script_archive($files->{'pear'}, $temp2, $d,
                                     $opts->{'dir'}.'/egw-pear',
				     "egroupware/egw-pear");
$err && return (0, "Failed to extract source : $err");

# Extract jpgraph
local $temp3 = &transname();
local $err = &extract_script_archive($files->{'jpgraph'}, $temp3, $d,
                                     $opts->{'dir'}.'/jpgraph',
				     "jpgraph-*");
$err && return (0, "Failed to extract source : $err");

# Create config file
local $cfile = "$opts->{'dir'}/header.inc.php";
local $cfilesrc = "$opts->{'dir'}/header.inc.php.template";

# Clean up mod_php settings in .htaccess file, if not needed
if (&get_domain_php_mode($d) ne "mod_php") {
	local $htaccess = "$opts->{'dir'}/.htaccess";
	local $lref = &read_file_lines($htaccess);
	foreach my $l (@$lref) {
		if ($l =~ /^php_/) {
			$l = "#".$l;
			}
		}
	&flush_file_lines_as_domain_user($d, $htaccess);
	}

if (!$upgrade) {
	# Make the install directory writable
	&make_file_php_writable($d, $opts->{'dir'}, 1);

	# Build params for config file creation
	local $mcrypt = &random_password(32);
	local @params = (
		[ 'ConfigLang', 'en' ],
		[ 'setting[server_root]', $opts->{'dir'} ],
		[ 'setting[header_admin_user]', $domuser ],
		[ 'setting[new_admin_password]', $dompass ],
		[ 'setting[setup_acl]', '' ],
		[ 'setting[db_persistent]', 'False' ],
		[ 'setting[session_handler]', 'egw_session_files' ],
		[ 'setting[mcrypt_enabled]', 'False' ],
		[ 'setting[mcrypt_iv]', $mcrypt ],
		[ 'setting[show_domain_selectbox]', 'True' ],
		[ 'domains[default]', 'default' ],
		[ 'setting_default[db_type]', 'mysql' ],
		[ 'setting_default[db_host]', $dbhost ],
		[ 'setting_default[db_port]', 3306 ],
		[ 'setting_default[db_name]', $dbname ],
		[ 'setting_default[db_user]', $dbuser ],
		[ 'setting_default[db_pass]', $dbpass ],
		[ 'setting_default[config_user]', $domuser ],
		[ 'setting_default[new_config_passwd]', $dompass ],
		[ 'action[write]', 'Write' ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/setup/manageheader.php";

	# Post to the header creation CGI
	local ($iout, $ierror, %gotheaders);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror, undef,
			      \%gotheaders);
	if ($ierror) {
		return (-1, "Configuration setup failed : $ierror");
		}

	# Submit to the setup login page, to get a session cookie
	local @params = (
		[ 'FormUser', $domuser ],
		[ 'ConfigLang', 'en' ],
		[ 'FormPW', $dompass ],
		[ 'FormDomain', 'default' ],
		[ 'ConfigLogin', 'Login' ],
		[ 'submit', 'Login' ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/setup/index.php";
	local ($iout, $ierror, %gotheaders);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror, undef,
			      \%gotheaders);
	if ($ierror) {
		return (-1, "Configuration login failed : $ierror");
		}
	local $cookie = $gotheaders{'set-cookie'};
	$cookie || return (-1, "Failed to get session cookie");

	# Build params for DB creation, then submit
	local %headers = ( 'Cookie', $cookie );
	local @params = (
		[ 'oldversion', 'new' ],
		[ 'action', 'Install' ],
		[ 'label', 'Install' ],
		[ 'system_charset', 'utf-8' ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/setup/index.php";
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror, \%headers);
	if ($ierror) {
		return (-1, "Database setup failed : $ierror");
		}

	# Create dirs
	local $base_dir = "$d->{'home'}/egroupware";
	local $files_dir = "$base_dir/files";
	local $backup_dir = "$base_dir/backup";
	&make_dir_as_domain_user($d, $files_dir, 0755, 1);
	&make_dir_as_domain_user($d, $backup_dir, 0755, 1);
	&make_file_php_writable($d, $base_dir, 1);
	&make_file_php_writable($d, $files_dir, 1);
	&make_file_php_writable($d, $backup_dir, 1);

	# Build params for config creation, then submit
	local $noslash = $opts->{'path'};
	$noslash =~ s/\/$//;
	local @params = (
		[ 'newsettings[vfs_storage_mode]', 'fs' ],
		[ 'newsettings[files_dir]', $files_dir ],
		[ 'newsettings[vfs_root_user]', '' ],
		[ 'newsettings[backup_dir]', $backup_dir ],
		[ 'newsettings[temp_dir]', '/tmp' ],
		[ 'newsettings[webserver_url]', $noslash ],
		[ 'newsettings[image_type]', 1 ],
		[ 'newsettings[aspell_path]', &has_command("aspell") ||
					      "/usr/bin/aspell" ],
		[ 'newsettings[hostname]', $d->{'dom'} ],
		[ 'newsettings[default_ftp_server]', 'localhost' ],
		[ 'newsettings[ftp_use_mime]', 'True' ],
		[ 'newsettings[mail_server]', 'localhost' ],
		[ 'newsettings[mail_server_type]', 'imap' ],
		[ 'newsettings[mail_login_type]', 'standard' ],
		[ 'newsettings[smtp_server]', 'localhost' ],
		[ 'newsettings[smtp_port]', 25 ],
		[ 'newsettings[smtp_auth_user]', $d->{'user'} ],
		[ 'newsettings[smtp_auth_passwd]', $d->{'pass'} ],
		[ 'newsettings[auth_type]', 'sql' ],
		[ 'newsettings[account_repository]', 'sql' ],
		[ 'newsettings[sql_encryption_type]', 'md5' ],
		[ 'newsettings[auto_create_expire]', '604800' ],
		[ 'newsettings[acl_default]', 'deny' ],
		[ 'submit', 'Save' ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/setup/config.php";
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror, \%headers);
	if ($ierror && $ierror !~ /Location/) {
		return (-1, "Database setup failed : $ierror");
		}

	# Build params for admin account creation
	local @params = (
		[ 'username', $domuser ],
		[ 'fname', $d->{'owner'} ],
		[ 'lname', '' ],
		[ 'email', $d->{'emailto_addr'} ],
		[ 'passwd', $dompass ],
		[ 'passwd2', $dompass ],
		[ 'submit', 'Save' ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/setup/admin_account.php";
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror, \%headers);
	if ($ierror && $ierror !~ /Location/) {
		return (-1, "Database setup failed : $ierror");
		}

	# Make config file not world readable
	if (&get_domain_php_mode($d) ne "mod_php") {
		&run_as_domain_user($d, "chmod 640 ".quotemeta($cfile));
		}

	# Link public_html/jpgraph to install dir
	&run_as_domain_user($d, "ln -s ".quotemeta("$opts->{'dir'}/jpgraph").
				" ".quotemeta(&public_html_dir($d)."/jpgraph"));
	}

SKIP:

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
local $adminurl = $url."setup/";
return (1, "eGroupWare installation complete. It can be accessed at <a target=_blank href='$url'>$url</a> , and setup at <a target=_blank href='$adminurl'>$adminurl</a> .", "Under $rp using $dbphptype database $dbname", $url, $domuser, $dompass);
}

# script_egroupware_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_egroupware_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Delete jpgraph link
&run_as_domain_user($d, "rm -f ".quotemeta(&public_html_dir($d)."/jpgraph"));

# Remove all egroupware_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "egw_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "eGroupWare directory and tables deleted.");
}

# script_egroupware_check_latest(version)
# Checks if some version is the latest for this project, and if not returns
# a newer one. Otherwise returns undef.
sub script_egroupware_check_latest
{
local ($ver) = @_;
local @vers = &osdn_package_versions("egroupware",
				     "eGroupware-([0-9\\.]+)\\.tar\\.gz");
return "Failed to find versions" if (!@vers);
return $ver eq $vers[0] ? undef : $vers[0];
}

sub script_egroupware_site
{
return 'http://www.egroupware.org/';
}

sub script_egroupware_passmode
{
return 1;
}

1;

