
# script_eticket_desc()
sub script_eticket_desc
{
return "eTicket";
}

sub script_eticket_uses
{
return ( "php" );
}

sub script_eticket_longdesc
{
return "eTicket is a widely-used open source support ticket system.";
}

# script_eticket_versions()
sub script_eticket_versions
{
return ( "1.7.3" );
}

sub script_eticket_php_modules
{
return ("mysql");
}

sub script_eticket_php_vers
{
return ( 5 );
}

sub script_eticket_dbs
{
return ("mysql");
}

# script_eticket_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_eticket_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for eTicket tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	$rv .= &ui_table_row("Title for helpdesk",
			     $upgrade->{'opts'}->{'title'});
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for eTicket tables",
		     &ui_database_select("db", undef, \@dbs, $d, "eticket"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("eticket", $d), 30, "At top level"));
	$rv .= &ui_table_row("Title for helpdesk",
			     &ui_textbox("title", "$d->{'owner'} helpdesk",30));
	$rv .= &ui_table_row("Create eticket\@$d->{'dom'} email alias?",
			     &ui_yesno_radio("ticketemail", 1));
	}
return $rv;
}

# script_eticket_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_eticket_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'title' => $in->{'title'},
		 'ticketemail' => $in->{'ticketemail'},
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_eticket_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_eticket_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
$opts->{'title'} || return "Missing title option";
if (-r "$opts->{'dir'}/admin.php") {
	return "eTicket appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "ticket_.*");
$clash && return "eTicket appears to be already using the selected database (table $clash)";
$opts->{'title'} ||= "$d->{'owner'} helpdesk";
return undef;
}

# script_eticket_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_eticket_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "eticket-$ver.zip",
	   'virtualmin' => 1,
	   'nocheck' => 1,
	   'url' => "http://www.eticketsupport.com/downloads/eticket.zip" } );
return @files;
}

sub script_eticket_commands
{
local ($d, $ver, $opts) = @_;
if ($opts->{'ticketemail'}) {
	return ("unzip");
	}
else {
	return ("unzip", "gcc");
	}
}

# script_eticket_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs eTicket, and returns either 1 and an informational
# message, or 0 and an error
sub script_eticket_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);

# Setup and get DB
if ($opts->{'newdb'} && !$upgrade) {
	local $err = &create_script_database($d, $opts->{'db'});
	return (0, "Database creation failed : $err") if ($err);
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "eTicket-$ver");
$err && return (0, "Failed to extract source : $err");

# Preserve config files
local $cfile = "$opts->{'dir'}/settings.php";
local $cfilesrc = "$opts->{'dir'}/settings.default.php";
local $oldcfile;
if ($upgrade) {
	$oldcfile = &transname();
	&copy_source_dest($cfile, $oldcfile);
	}
local $acfile = "$opts->{'dir'}/automail-settings.pl";
local $oldacfile;
if ($upgrade) {
	$oldacfile = &transname();
	&copy_source_dest($acfile, $oldacfile);
	}

if (!-r $cfile) {
	# Use template config file
	&copy_source_dest_as_domain_user($d, $cfilesrc, $cfile);
	}
&make_file_php_writable($d, $cfile);
&make_file_php_writable($d, $acfile);
&make_file_php_writable($d, "$opts->{'dir'}/attachments");

local $url = &script_path_url($d, $opts);
local $piper = "$opts->{'dir'}/pipe.php";
&make_file_php_writable($d, $piper);
if ($upgrade) {
	# Put back old config files
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	&copy_source_dest_as_domain_user($d, $oldacfile, $acfile);
	}
else {
	# Fix rootpath_dir in settings.php
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	foreach my $l (@$lref) {
		if ($l =~ /^\s*\$rootpath_dir\s*=/) {
			$l = "\$rootpath_dir = '$opts->{'dir'}/';";
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);

	# Create parameters for the database setup URL
	local @params = (
	    [ "db_type", "mysql" ],
	    [ "db_host", $dbhost ],
	    [ "db_name", $dbname ],
	    [ "db_user", $dbuser ],
	    [ "db_pass", $dbpass ],
	    [ "db_table_prefix", "ticket_" ],
	    [ "db_table_tickets", "tickets" ],
	    [ "step", 3 ],
	    );
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install/install.php";

	# Make an HTTP post to the database setup URL
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "eTicket database setup failed : $ierror");
		}
	elsif ($iout !~ /Enter\s+your\s+settings/i) {
		print STDERR $iout;
		return (-1, "eTicket database setup failed");
		}

	# Create params for admin setup
	local $noslash = $url;
	$noslash =~ s/\/$//;
	@params = grep { $_->[0] ne 'step' } @params;
	push(@params, 
	    [ "perlpath", &get_perl_path() ],
	    [ "admin_user", "admin" ],
	    [ "admin_pass", $dompass ],
	    [ "admin_name", $d->{'owner'} ],
	    [ "admin_email", $d->{'emailto_addr'} ],
	    [ "cat_name", "Support" ],
	    [ "cat_email", $d->{'emailto'} ],
	    [ "rootpath_dir", $opts->{'dir'}.'/' ],
	    [ "root_url", $noslash ],
	    [ "site_title", $opts->{'title'} ],
	    [ "attachment_dir", $opts->{'dir'}.'/attachments/' ],
	    [ "no_return", "nobody\@$d->{'dom'}" ],
	    [ "step", 4 ],
	    );
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install/install.php";

	# Make an HTTP post to the admin setup URL
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "eTicket admin setup failed : $ierror");
		}

	# Remove the install directory
	$out = &run_as_domain_user($d, "rm -rf ".
				   quotemeta("$opts->{'dir'}/install"));

	if ($opts->{'ticketemail'}) {
		# Create the binary wrapper for email
		local $wrappersrc = &transname("pipe-wrapper.c");
		local $wrapname = "eticket-pipe-wrapper-$d->{'id'}";
		local $wrapper = "$module_config_directory/$wrapname";
		$opts->{'wrapper'} = $wrapper;
		&open_tempfile(SRC, ">$wrappersrc", 0, 1);
		&print_tempfile(SRC, "#include <stdio.h>\n");
		&print_tempfile(SRC, "int main(int argc, char **argv)\n");
		&print_tempfile(SRC, "{\n");
		&print_tempfile(SRC, "setuid(geteuid());\n");
		&print_tempfile(SRC, "setgid(getegid());\n");
		&print_tempfile(SRC, "chdir(\"$opts->{'dir'}\");\n");
		&print_tempfile(SRC, "execv(\"$piper\", argv);\n");
		&print_tempfile(SRC, "}\n");
		&close_tempfile(SRC);
		$out = &backquote_command(
		    "gcc -o ".quotemeta($wrapper)." ".quotemeta($wrappersrc));
		if ($?) {
			return (-1, "Email wrapper compile failed : $out");
			}
		&set_ownership_permissions(
		    $d->{'uid'}, $d->{'gid'}, 06755, $wrapper);

		# Create the mail handling alias, if missing
		&obtain_lock_mail($d);
		local ($virt) = grep { $_->{'from'} eq 'eticket@'.$d->{'dom'} }
				     &list_virtusers();
		if (!$virt) {
			$virt = { 'from' => 'eticket@'.$d->{'dom'},
				  'to' => [ "|$wrapper" ] };
			&create_virtuser($virt);
			if ($config{'mail_system'} == 1 &&
			    -d "/etc/smrsh" &&
			    !-e "/etc/smrsh/$wrapname") {
				symlink($wrapper, "/etc/smrsh/$wrapname");
				}
			}
		&release_lock_mail($d);
		}
	}

# Fix up PHP path in pipe.php
local ($phpinfo) = grep { $_->[0] == $opts->{'phpver'} }
		     	&list_available_php_versions($d);
local $phpcmd = $phpinfo->[1] || "php";
$phpcmd =~ s/-cgi$//;
local $lref = &read_file_lines_as_domain_user($d, $piper);
$lref->[0] = "#!$phpcmd";
&flush_file_lines_as_domain_user($d, $piper);
&set_permissions_as_domain_user($d, 0755, $piper);

# Return a URL for the user
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
local $adminurl = $url."admin.php";
return (1, "eTicket installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>, and managed at <a target=_blank href='$adminurl'>$adminurl</a>.", "Under $rp using $dbphptype database $dbname", $url, "admin", $dompass);
}

# script_eticket_uninstall(&domain, version, &opts)
# Un-installs an eTicket installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_eticket_uninstall
{
local ($d, $version, $opts) = @_;

# Remove all ost_ tables from the database
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
&cleanup_script_database($d, $opts->{'db'}, "ticket_");
&cleanup_script_database($d, $opts->{'db'}, [ "tickets" ]);

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Take out the DB
if ($opts->{'newdb'}) {
	&delete_script_database($d, $opts->{'db'});
	}

# Take out the mail alias and wrapper
local $wrapper = $opts->{'wrapper'};
if ($wrapper && $opts->{'ticketemail'}) {
	local $wrapname = $wrapper;
	$wrapname =~ s/^.*\///;
	&obtain_lock_mail($d);
	local ($virt) = grep { $_->{'from'} eq 'eticket@'.$d->{'dom'} &&
			       $_->{'to'}->[0] eq "|$wrapper" }
			     &list_virtusers();
	if ($virt) {
		&delete_virtuser($virt);
		if (readlink("/etc/smrsh/$wrapname") eq $wrapper) {
			&unlink_file("/etc/smrsh/$wrapname");
			}
		}
	&unlink_file($wrapper);
	&release_lock_mail($d);
	}

return (1, "eTicket directory and tables deleted.");
}

# script_eticket_latest(version)
#sub script_eticket_latest
#{
#return ( "http://www.eticketsupport.com/downloads/",
#	 "v([0-9\\.]+).*\\.zip" );
#}

#sub script_eticket_site
#{
#return 'http://eticket.sourceforge.net/';
#}

sub script_eticket_passmode
{
return 2;
}

1;

