
# script_extplorer_desc()
sub script_extplorer_desc
{
return "eXtplorer";
}

sub script_extplorer_uses
{
return ( "php" );
}

sub script_extplorer_longdesc
{
return "eXtplorer is a web-based File Manager.";
}

# script_extplorer_versions()
sub script_extplorer_versions
{
return ( "2.1.5" );
}

sub script_extplorer_php_vers
{
local ($d, $ver) = @_;
return ( 5 );
}

sub script_extplorer_depends
{
local ($d, $ver) = @_;
local @rv;
local $mode = &get_domain_php_mode($d);
$mode eq "mod_php" &&
	push(@rv, "eXtplorer requires that PHP scripts be executed fcgid or cgi modes, so that they can modify your files");
return @rv;
}

# script_extplorer_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_extplorer_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
		     &ui_textbox("dir", &substitute_scriptname_template("extplorer", $d), 30));
	}
return $rv;
}

# script_extplorer_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_extplorer_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = "$hdir/$in{'dir'}";
	return { 'dir' => $dir,
		 'path' => "/$in{'dir'}", };
	}
}

# script_extplorer_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_extplorer_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/config/.htusers.php") {
	return "eXtplorer appears to be already installed in the selected directory";
	}
return undef;
}

# script_extplorer_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Twiki, each of which is a hash ref
# containing a name, filename and URL
sub script_extplorer_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "explorer_$ver.zip",
	   'url' => "http://downloads.sourceforge.net/extplorer/eXtplorer_$ver.zip" } );
return @files;
}

sub script_extplorer_commands
{
return ("unzip");
}

# script_extplorer_install(&domain, version, &opts, &files, &upgrade-info,
# 			   [user, pass])
# Actually installs PhpWiki, and returns either 1 and an informational
# message, or 0 and an error
sub script_extplorer_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);

# Preserve old config file
local $cfile = "$opts->{'dir'}/config/.htusers.php";
local $oldcfile = &transname();
if ($upgrade) {
	&copy_source_dest($cfile, $oldcfile);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'});
$err && return (0, "Failed to extract source : $err");

local $url = &script_path_url($d, $opts);
if ($upgrade) {
	# Put back original config file
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	}
else {
	# Edit the config file
	eval "use Digest::MD5";
	local $md5;
	if (!$@) {
		$md5 = Digest::MD5::md5_hex($dompass);
		}
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	foreach my $l (@$lref) {
		if ($l =~ /^(.*)"admin","([^"]+)"(.*)/) {
			$l = $1."\"$domuser\",\"$md5\"".$3;
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);
	}

local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "eXtplorer installation complete. It can be accessed at <a href='$url' target=_blank>$url</a>", "Under $rp", $url, $domuser, $dompass);
}

# script_extplorer_uninstall(&domain, version, &opts)
# Un-installs an eXtplorer installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_extplorer_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

return (1, "eXtplorer directory deleted.");
}

# script_extplorer_check_latest()
sub script_extplorer_check_latest
{
local ($ver) = @_;
local @vers = &osdn_package_versions("extplorer",
				     "eXtplorer_([0-9\\.]+)\\.zip");
return "Failed to find versions" if (!@vers);
return $ver eq $vers[0] ? undef : $vers[0];
}

sub script_extplorer_site
{
return "http://extplorer.sourceforge.net/";
}

sub script_extplorer_passmode
{
return 1;
}

1;

