
# script_faqmasterflex_desc()
sub script_faqmasterflex_desc
{
return "FAQMasterFlex";
}

sub script_faqmasterflex_uses
{
return ( "php" );
}

sub script_faqmasterflex_longdesc
{
return "This is a database-driven application for creating and maintaining Frequently Asked Questions.";
}

# script_faqmasterflex_versions()
sub script_faqmasterflex_versions
{
return ( "1.0" );
}

sub script_faqmasterflex_abandoned
{
return 2;
}

sub script_faqmasterflex_category
{
return "Helpdesk";
}

sub script_faqmasterflex_php_vers
{
return ( 4, 5 );
}

sub script_faqmasterflex_php_modules
{
return ("mysql");
}

sub script_faqmasterflex_dbs
{
return ("mysql");
}

# script_faqmasterflex_depends(&domain, version)
sub script_faqmasterflex_depends
{
local ($d, $ver) = @_;
local @rv;
local $mode = &get_domain_php_mode($d);
$mode eq "mod_php" ||
	push(@rv, "FAQMasterFlex requires that PHP scripts be executed using mod_php");
return @rv;
}

# script_faqmasterflex_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_faqmasterflex_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for FAQMasterFlex tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for FAQMasterFlex tables",
		     &ui_database_select("db", undef, \@dbs, $d, "faqmasterflex"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("faq", $d), 30, "At top level"));
	}
return $rv;
}

# script_faqmasterflex_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_faqmasterflex_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_faqmasterflex_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_faqmasterflex_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/faq.php") {
	return "FAQMasterFlex appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "faq.*");
$clash && return "FAQMasterFlex appears to be already using the selected database (table $clash)";
return undef;
}

# script_faqmasterflex_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_faqmasterflex_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "faqmasterflex.zip",
	   'url' => "http://software.virtualmin.com/download/faqmasterflex.zip" } );
return @files;
}

sub script_faqmasterflex_commands
{
return ("unzip");
}

# script_faqmasterflex_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs FAQMasterFlex, and returns either 1 and an informational
# message, or 0 and an error
sub script_faqmasterflex_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
			     $opts->{'dir'}, "FAQMasterFlex/FAQMasterFlex");
$err && return (0, "Failed to extract source : $err");
local $cfile = "$opts->{'dir'}/faq_config.php";

# Update config file
local $lref = &read_file_lines_as_domain_user($d, $cfile);
local $l;
foreach $l (@$lref) {
	if ($l =~ /^\$link\s*=\s*mysql_connect\(/) {
		$l = "\$link = mysql_connect(\"$dbhost\",\"$dbuser\",\"".
		     &php_quotemeta($dbpass)."\");";
		}
	if ($l =~ /^mysql_select_db\(/) {
		$l = "mysql_select_db(\"$dbname\");";
		}
	if ($l =~ /^\$username\s*=/) {
		$l = "\$username = \"$domuser\";";
		}
	if ($l =~ /^\$password\s*=/) {
		$l = "\$password = \"$dompass\";";
		}
	if ($l =~ /^\$db_server\s*=/) {
		$l = "\$db_server = \"$dbhost\";";
		}
	if ($l =~ /^\$db_username\s*=/) {
		$l = "\$db_username = \"$dbuser\";";
		}
	if ($l =~ /^\$db_password\s*=/) {
		$l = "\$db_password = \"".&php_quotemeta($dbpass)."\";";
		}
	if ($l =~ /^\$db_databasename\s*=/) {
		$l = "\$db_databasename = \"$dbname\";";
		}
	}
&flush_file_lines_as_domain_user($d, $cfile);

# Run the SQL
local $sqlfile = "$temp/FAQMasterFlex/faqmasterflex.sql";
&require_mysql();
local ($ex, $out) = &mysql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
$ex && return (0, "Failed to run database setup script : <tt>$out</tt>.");

# Return a URL for the user
local $url = &script_path_url($d, $opts)."faq_admin.php";
local $userurl = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "FAQMasterFlex installation complete. It can be managed at <a target=_blank href='$url'>$url</a>.", "Under $rp using $dbphptype database $dbname", $userurl, $domuser, $dompass);
}

# script_faqmasterflex_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_faqmasterflex_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all faw tables from the database
&cleanup_script_database($d, $opts->{'db'}, "faq_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "FAQMasterFlex directory and tables deleted.");
}

sub script_faqmasterflex_site
{
return 'http://www.lethalpenguin.net/design/faqmasterflex.php';
}

sub script_faqmasterflex_passmode
{
return 1;
}

1;

