
# script_imp_desc()
sub script_imp_desc
{
return "IMP";
}

sub script_imp_uses
{
return ( "php", "horde" );
}

sub script_imp_longdesc
{
return "IMP is a PHP-based webmail system, which is part of the Horde project.";
}

# script_imp_versions()
sub script_imp_versions
{
return ( "h3-4.3.11" );
}

sub script_imp_category
{
return "Horde";
}

# script_imp_depends(&domain, version)
sub script_imp_depends
{
local ($d, $ver) = @_;

# Check for horde install
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
return ("IMP requires that Horde be installed first") if (!$horde);

return ( );
}

# script_imp_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_imp_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^\Q$d->{'home'}\E\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local $odir = $horde->{'opts'}->{'dir'};
	$odir =~ s/^\Q$d->{'home'}\E\///;
	$rv .= &ui_table_row("Install sub-directory under <tt>$odir</tt>",
			     &ui_textbox("dir", "imp", 30));
	}
return $rv;
}

# script_imp_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_imp_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local @scripts = &list_domain_scripts($d);
	local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
	$in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = "$horde->{'opts'}->{'dir'}/$in{'dir'}";
	$dir =~ s/\/\//\//g;
	local $path = "$horde->{'opts'}->{'path'}/$in{'dir'}";
	$path =~ s/\/\//\//g;
	return { 'dir' => $dir,
		 'path' => $path,
		 'horde' => 1 };
	}
}

# script_imp_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_imp_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/index.php") {
	return "IMP appears to be already installed in the selected directory";
	}
return undef;
}

# script_imp_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by IMP, each of which is a hash ref
# containing a name, filename and URL
sub script_imp_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "imp-$ver.tar.gz",
	   'url' => "ftp://ftp.horde.org/pub/imp/imp-$ver.tar.gz" } );
return @files;
}

sub script_imp_commands
{
return ("tar", "gunzip");
}

# script_imp_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs IMP, and returns either 1 and an informational
# message, or 0 and an error
sub script_imp_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "imp-$ver");
$err && return (0, "Failed to extract source : $err");

# Copy the config files
local $cdir = "$opts->{'dir'}/config";
opendir(DIR, $cdir);
foreach my $f (readdir(DIR)) {
	if ($f =~ /^(.*)\.dist$/ && !-r "$cdir/$1") {
		&run_as_domain_user($d, "cp ".quotemeta("$cdir/$f")." ".
					      quotemeta("$cdir/$1"));
		&make_file_php_writable($d, "$cdir/$1");
		}
	}
closedir(DIR);
&make_file_php_writable($d, $cdir, 1);

if (!$upgrade) {
	# Make the first IMAP server the default
	local $lref = &read_file_lines_as_domain_user(
				$d, "$opts->{'dir'}/config/servers.php");
	foreach my $l (@$lref) {
		if ($l =~ /'server'\s*=>\s*/) {
			$l = "    'server' => 'localhost',";
			}
		if ($l =~ /'name'\s*=>\s*/ && $l !~ /Choose/) {
			$l = "    'name' => '$d->{'dom'} IMAP Server',";
			}
		if ($l =~ /'folders'\s*=>\s*/) {
			$l = "    'folders' => '',";
			}
		if ($l =~ /'hordeauth'\s*=>\s*/) {
			$l = "    'hordeauth' => true,";
			}
		if ($l =~ /'maildomain'\s*=>\s*/) {
			$l = "    'maildomain' => '$d->{'dom'}',";
			}
		if ($l =~ /'smtphost'\s*=>\s*/) {
			$l = "    'smtphost' => 'localhost',";
			}
		if ($l =~ /'preferred'\s*=>\s*/) {
			$l = "    'preferred' => '1',";
			}
		if ($l =~ /^\s*\$servers\['([a-z0-9]+)'\]/ && $1 ne "imap") {
			last;	# end of first server
			}
		}
	&flush_file_lines_as_domain_user(
		$d, "$opts->{'dir'}/config/servers.php");

	# Use hidden mode for servers by default
	local $lref = &read_file_lines_as_domain_user(
			$d, "$opts->{'dir'}/config/conf.php");
	push(@$lref, "<?php");
	push(@$lref, "\$conf['server']['server_list'] = 'hidden';");
	&flush_file_lines_as_domain_user($d, "$opts->{'dir'}/config/conf.php");
	&make_file_php_writable($d, "$opts->{'dir'}/config/conf.php");
	}

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "IMP installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>. However, it must first be configured using Horde at <a target=_blank href='$horde->{'url'}'>$horde->{'url'}</a>, on the Setup page under Administration.", "Under $rp", $url);
}

# script_imp_uninstall(&domain, version, &opts)
# Un-installs a IMP installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_imp_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

return (1, "IMP directory deleted.");
}

# script_imp_latest()
# Returns a URL and regular expression or callback func to get the version
sub script_imp_latest
{
return ( "http://ftp.horde.org/pub/imp/",
         "imp-(h3-[0-9\\.]+)\\.tar\\.gz" );
}

sub script_imp_site
{
return 'http://www.horde.org/imp/';
}

1;

