
# script_integramod_desc()
sub script_integramod_desc
{
return "IntegraMOD";
}

sub script_integramod_uses
{
return ( "php" );
}

sub script_integramod_longdesc
{
return "IntegraMOD is a pre-modded version of phpBB with great modifications that are made compatible with each other.";
}

# script_integramod_versions()
sub script_integramod_versions
{
return ( "1.4.1" );
}

sub script_integramod_category
{
return "Community";
}

sub script_integramod_php_vers
{
return ( 4, 5 );
}

sub script_integramod_php_modules
{
local ($d, $ver, $phpver, $opts) = @_;
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
return $dbtype eq "mysql" ? ("mysql") : ("pgsql");
}

sub script_integramod_dbs
{
return ("mysql", "postgres");
}

# script_integramod_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing IntegraMOD
sub script_integramod_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for Integramod tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql", "postgres" ]);
	$rv .= &ui_table_row("Database for Integramod tables",
		     &ui_database_select("db", undef, \@dbs, $d, "integramod"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("integramod", $d), 30, "At top level"));
	}
return $rv;
}

# script_integramod_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_integramod_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
	         'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_integramod_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_integramod_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/config.php") {
	return "IntegraMOD appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "phpbb_");
$clash && return "Integramod appears to be already using the selected database (table $clash)";
return undef;
}

# script_integramod_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by IntegraMOD, each of which is a hash ref
# containing a name, filename and URL
sub script_integramod_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local $fver = $ver;
$fver =~ s/\.//g;
local @files = ( { 'name' => "source",
	   'file' => "IntegraMOD-$ver.zip",
	   'url' => "http://software.virtualmin.com/download/integramod-$ver.zip" } );
return @files;
}

sub script_integramod_commands
{
return ("unzip");
}

# script_integramod_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs IntegraMOD, and returns either 1 and an informational
# message, or 0 and an error
sub script_integramod_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
	local $err = &create_script_database($d, $opts->{'db'});
	return (0, "Database creation failed : $err") if ($err);
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "psql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Preserve old config file
local $cfile = "$opts->{'dir'}/config.php";
local $oldcfile = &transname();
if ($upgrade) {
	&copy_source_dest($cfle, $oldcfile);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "IM141");
$err && return (0, "Failed to extract source : $err");

local $url = &script_path_url($d, $opts);
if ($upgrade) {
	# Put back original config file
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	}
else {
	# Make config.php writable
	&make_file_php_writable($d, $cfile);
	&make_file_php_writable($d,
		"$opts->{'dir'}/includes/phpbb_security.php");

	# Trigger the installation PHP script
	local @params = (
		[ "lang", "english" ],
		[ "dbms", $dbtype eq "mysql" ? "mysql4" : "postgres" ],
		[ "upgrade", 0 ],
		[ "dbhost", $dbhost ],
		[ "dbname", $dbname ],
		[ "dbuser", $dbuser ],
		[ "dbpasswd", $dbpass ],
		[ "prefix", "phpbb_" ],
		[ "board_email", $d->{'emailto_addr'} ],
		[ "server_name", "www.".$d->{'dom'} ],
		[ "server_port", $d->{'web_port'} ],
		[ "script_path", $opts->{'path'}."/" ],
		[ "admin_name", $domuser ],
		[ "admin_pass1", $dompass ],
		[ "admin_pass2", $dompass ],
		[ "install_step", 1 ],
		[ "cur_lang", "english" ],
		[ "no_prill_install", 1 ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install/install.php";

	# Make an HTTP post to the installer page
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "Integramod post-install configuration failed : $ierror");
		}
	#elsif ($iout !~ /Finish Installation/i) {
	#	return (0, "Integramod post-install configuration failed");
	#	}

	# Delete the contrib and install directories
	$out = &run_as_domain_user($d, "rm -rf ".
			quotemeta("$opts->{'dir'}/contrib")." ".
			quotemeta("$opts->{'dir'}/install")." ".
			quotemeta("$opts->{'dir'}/prill_install"));
	}

# Tell the user about the new install
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Initial IntegraMOD installation complete. Go to <a target=_blank href='$url'>$url</a> to use it.", "Under $rp using $dbphptype database $dbname", $url, $domuser, $dompass);
}

# script_integramod_uninstall(&domain, version, &opts)
# Un-installs a IntegraMOD installation, by removing it's files
# Returns 1 on success and a message, or 0 on failure and an error
sub script_integramod_uninstall
{
local ($d, $version, $opts) = @_;

# Remove Integramod tables from the database
&cleanup_script_database($d, $opts->{'db'}, "phpbb_");

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Take out the DB
if ($opts->{'newdb'}) {
	&delete_script_database($d, $opts->{'db'});
	}

return (1, $deldb ? "Deleted IntegraMOD directory and tables."
		  : "Deleted IntegraMOD directory.");
}

# script_integramod_latest(version)
# Returns a URL and regular expression or callback func to get the version
sub script_integramod_latest
{
return ( "http://www.integramod.com/forum/viewforum.php?f=3",
	 "IntegraMOD\\s+([0-9\\.]+)\\s+is\\s+available\\s+now" );
}

sub script_integramod_site
{
return 'http://www.integramod.com/';
}

sub script_integramod_passmode
{
return 1;
}

1;

