
# script_joomla_desc()
sub script_joomla_desc
{
return "Joomla";
}

sub script_joomla_uses
{
return ( "php" );
}

# script_joomla_longdesc()
sub script_joomla_longdesc
{
return "Joomla is a powerful Open Source Content Management System.";
}

# script_joomla_versions()
sub script_joomla_versions
{
return ( "3.3.0", "2.5.20", "1.7.5", "1.6.6", "1.5.26", "1.0.15" );
}

sub script_joomla_abandoned
{
local ($ver) = @_;
return $ver < 2 ? 1 : 0;
}

sub script_joomla_version_desc
{
local ($ver) = @_;
return $ver >= 3.0 ? "$ver (Development)" : $ver;
}

sub script_joomla_release
{
return 4;		# Roll back incorrect version bump
}

sub script_joomla_depends
{
local ($d, $ver, $sinfo, $phpver) = @_;
local @rv;
if ($ver >= 3.0) {
	# Check for PHP 5.3+
	local $phpv = &get_php_version($phpver || 5, $d);
	if (!$phpv) {
		push(@rv, "Could not work out exact PHP version");
		}
	elsif ($phpv < 5.3) {
		push(@rv, "Joomla 3.0 and above requires PHP version 5.3 or later");
		}
	}
return @rv;
}

# script_joomla_can_upgrade(&sinfo, newver)
sub script_joomla_can_upgrade
{
local ($sinfo, $newver) = @_;
if ($newver >= 1.5 && $sinfo->{'version'} < 1.5) {
	# Cannot upgrade from 1.4 to 1.5
	return 0;
	}
if ($newver >= 1.6 && $sinfo->{'version'} < 1.6) {
	# Cannot upgrade from 1.5 to 1.6
	return 0;
	}
if ($newver >= 3.0 && $sinfo->{'version'} < 3.0) {
	# Cannot upgrade from < 3.0 and 3.x
	return 0;
	}
return 1;
}

sub script_joomla_category
{
return "Content Management System";
}

sub script_joomla_php_vers
{
local ($d, $ver) = @_;
return $ver >= 1.5 ? ( 5 ) : ( 4, 5 );
}

#sub script_joomla_php_vars
#{
#return ( [ 'magic_quotes_gpc', 'On' ] );
#}

sub script_joomla_php_modules
{
local ($d, $ver, $phpver, $opts) = @_;
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
return $dbtype eq "mysql" ? ("mysql") : ("pgsql");
}

sub script_joomla_perl_modules
{
return ( "Digest::MD5" );
}

sub script_joomla_dbs
{
return ("mysql", "postgres");
}

# script_joomla_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing joomla
sub script_joomla_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for Joomla tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql", "postgres" ]);
	$rv .= &ui_table_row("Database for Joomla tables",
		     &ui_database_select("db", undef, \@dbs, $d, "joomla"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("joomla", $d), 30, "At top level"));
	#$rv .= &ui_table_row("Language version",
	#		     &ui_select("lang", "en",
	#				[ [ "en", "English" ],
	#				  [ "es", "Spanish" ] ]));
	$rv .= &ui_hidden("lang", "en");
	$rv .= &ui_table_row("Install sample content?",
			     &ui_yesno_radio("sample", 1));
	}
return $rv;
}

# script_joomla_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_joomla_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in->{'dir_def'} ? "/" : "/$in->{'dir'}",
		 'lang' => $in->{'lang'},
		 'sample' => $in->{'sample'}, };
	}
}

# script_joomla_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_joomla_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/configuration.php") {
	return "Joomla appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "jos_.*");
$clash && return "Joomla appears to be already using the selected database (table $clash)";
return undef;
}

# script_joomla_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by joomla, each of which is a hash ref
# containing a name, filename and URL
sub script_joomla_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local $usver = $ver;
$usver =~ s/\./_/g;
local @files = ( { 'name' => "source",
	   'file' => "Joomla_$ver-Full_Package.tar.gz",
	   'url' =>
	$opts->{'lang'} eq 'es' ?
	 "http://developer.joomla.org/sf/frs/do/downloadFile/projects.spanish/".
	 "frs.joomla_spanish_premium.joomla_spanish_1_0_12/frs8254?dl=1" :
	$ver < 1.5 ?
	  "http://joomlacode.org/gf/download/frsrelease/6828/22537/".
	  "Joomla_$ver-Stable-Full_Package.tar.gz" :
	$ver < 1.6 ?
	  "http://joomlacode.org/gf/download/frsrelease/16890/73389/".
	  "Joomla_$ver-Stable-Full_Package.tar.gz" :
	$ver < 1.7 ?
	  "http://joomlacode.org/gf/download/frsrelease/15379/66854/".
	  "Joomla_$ver-Stable-Full_Package.tar.gz" :
	$ver < 2.5 ?
	  "http://joomlacode.org/gf/download/frsrelease/16516/72048/".
	  "Joomla_$ver-Stable-Full_Package.tar.gz" :
	$ver < 3.0 ?
	  "http://joomlacode.org/gf/download/frsrelease/19395/158839/".
	  "Joomla_$ver-Stable-Full_Package.tar.gz" :
	$ver >= 3.0 ?
	  "http://joomlacode.org/gf/download/frsrelease/19393/158833/".
	  "Joomla_$ver-Stable-Full_Package.tar.gz" :
	  undef,
	} );
return @files;
}

sub script_joomla_commands
{
return ("tar", "gunzip");
}

# script_joomla_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs joomla, and returns either 1 and an informational
# message, or 0 and an error
sub script_joomla_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;

# Disallow major version upgrade
if ($ver >= 1.5 && $upgrade && $upgrade->{'version'} < 1.5) {
	return (0, "Joomla cannot be upgraded from versions before 1.5 to version 1.5 or later");
	}
if ($ver >= 1.6 && $upgrade && $upgrade->{'version'} < 1.6) {
	return (0, "Joomla cannot be upgraded from versions before 1.6 to version 1.6 or later");
	}

local ($out, $ex);
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
if ($opts->{'newdb'} && !$upgrade) {
	local $dbopts;
	if ($dbtype eq "mysql" && $version >= 1.5) {
		$dbopts = { 'charset' => 'utf8' };
		}
        local $err = &create_script_database($d, $opts->{'db'}, $dbopts);
        return (0, "Database creation failed : $err") if ($err);
        }
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, undef);
$err && return (0, "Failed to extract source : $err");
local $cfile = "$opts->{'dir'}/configuration.php";
if (!-r $cfile) {
	local $cdef = $ver < 1.6 ? "$opts->{'dir'}/configuration.php-dist"
			 : "$opts->{'dir'}/installation/configuration.php-dist";
	&run_as_domain_user($d, "cp ".quotemeta($cdef)." ".quotemeta($cfile));
	}

# Fix htaccess files in extracted dir
if (!$config{'allow_symlinks'} && defined(&fix_script_htaccess_files)) {
	&fix_script_htaccess_files($d, $temp, 0, "htaccess.txt");
	}

# Update database details in config.php
local $url = &script_path_url($d, $opts);
if (!$upgrade) {
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	local $l;
	$opts->{'joomla_secret'} ||= &random_password(20);
	local $mode = &get_domain_php_mode($d);
	local $qowner = &php_quotemeta($d->{'owner'});
	foreach $l (@$lref) {
		# Joomla < 1.5 settings
		if ($l =~ /^\$mosConfig_host\s*=/) {
			$l = "\$mosConfig_host = \'$dbhost\';";
			}
		if ($l =~ /^\$mosConfig_user\s*=/) {
			$l = "\$mosConfig_user = \'$dbuser\';";
			}
		if ($l =~ /^\$mosConfig_password\s*=/) {
			$l = "\$mosConfig_password = \'".
			     &php_quotemeta($dbpass)."\';";
			}
		if ($l =~ /^\$mosConfig_dbprefix\s*=/) {
			$l = "\$mosConfig_dbprefix = \'jos_\';";
			}
		if ($l =~ /^\$mosConfig_db\s*=/) {
			$l = "\$mosConfig_db = \'$dbname\';";
			}
		if ($l =~ /^\$mosConfig_live_site\s*=/) {
			local $noslash = $url;
			$noslash =~ s/\/$//;
			$l = "\$mosConfig_live_site = \'$noslash\';";
			}
		if ($l =~ /^\$mosConfig_absolute_path\s*=/) {
			local $noslashd = "$opts->{'dir'}/";
			$noslashd =~ s/\/$//;
			$l = "\$mosConfig_absolute_path = \'$noslashd\';";
			}
	       if ($l =~ /^\$mosConfig_cachepath\s*=/) {
			local $noslashdd = "$opts->{'dir'}/cache/";
			$noslashdd =~ s/\/$//;
			$l = "\$mosConfig_cachepath = \'$noslashdd\';";
		       }
		if ($l =~ /^\$mosConfig_lang\s*=/ && $opts->{'lang'} eq 'es') {
			$l = "\$mosConfig_lang = 'spanish';";
			}
		if ($l =~ /^\$mosConfig_locale\s*=/ && $opts->{'lang'} eq 'es') {
			$l = "\$mosConfig_locale = 'es_ES';";
			}
		if ($l =~ /^\$mosConfig_fileperms\s*=/) {
			$l = "\$mosConfig_fileperms = '755';";
			}
		if ($l =~ /^\$mosConfig_dirperms\s*=/) {
			$l = "\$mosConfig_dirperms = '755';";
			}

		# Joomla 1.5 and 1.6 options
		if ($l =~ /^\s*(var|public)\s+\$dbtype\s*=/) {
			$l = "$1 \$dbtype = '$dbtype';";
			}
		if ($l =~ /^\s*(var|public)\s+\$host\s*=/) {
			$l = "$1 \$host = '$dbhost';";
			}
		if ($l =~ /^\s*(var|public)\s+\$user\s*=/) {
			$l = "$1 \$user = '$dbuser';";
			}
		if ($l =~ /^\s*(var|public)\s+\$password\s*=/) {
			$l = "$1 \$password = '".
			     &php_quotemeta($dbpass)."';";
			}
		if ($l =~ /^\s*(var|public)\s+\$db\s*=/) {
			$l = "$1 \$db = '$dbname';";
			}
		if ($l =~ /^\s*(var|public)\s+\$secret\s*=/) {
			$l = "$1 \$secret = '$opts->{'joomla_secret'}';";
			}
		if ($l =~ /^\s*(var|public)\s+\$ftp_host\s*=/) {
			$l = "$1 \$ftp_host = 'localhost';";
			}
		if ($l =~ /^\s*(var|public)\s+\$ftp_port\s*=/) {
			$l = "$1 \$ftp_port = '21';";
			}
		if ($l =~ /^\s*(var|public)\s+\$ftp_user\s*=/) {
			$l = "$1 \$ftp_user = '$d->{'user'}';";
			}
		if ($l =~ /^\s*(var|public)\s+\$ftp_pass\s*=/) {
			$l = "$1 \$ftp_pass = '$d->{'pass'}';";
			}
		if ($l =~ /^\s*(var|public)\s+\$ftp_root\s*=/) {
			$l = "$1 \$ftp_root = '$opts->{'dir'}';";
			}
		if ($l =~ /^\s*(var|public)\s+\$ftp_layer\s*=/) {
			if ($mode eq "mod_php") {
				$l = "$1 \$ftp_layer = '1';";
				}
			else {
				$l = "$1 \$ftp_layer = '0';";
				}
			}
		if ($l =~ /^\s*(var|public)\s+\$ftp_enable\s*=/) {
			if ($mode eq "mod_php") {
				$l = "$1 \$ftp_enable = '1';";
				}
			else {
				$l = "$1 \$ftp_enable = '0';";
				}
			}
		if ($l =~ /^\s*(var|public)\s+\$log_path\s*=/) {
			$l = "$1 \$log_path = '$d->{'home'}/logs';";
			}
		if ($l =~ /^\s*(var|public)\s+\$mailfrom\s*=/) {
			$l = "$1 \$mailfrom = '$d->{'emailto_addr'}';";
			}
		if ($l =~ /^\s*(var|public)\s+\$fromname\s*=/) {
			$l = "$1 \$fromname = '$qowner';";
			}
		if ($l =~ /^\s*(var|public)\s+\$sitename\s*=/) {
			$l = "$1 \$sitename = '$qowner';";
			}
		if ($mode ne "mod_php") {
			if ($l =~ /^\s*(var|public)\s+\$sef\s*=/) {
				$l = "$1 \$sef = '0';";
				}
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);
	}

# Set permissions
foreach my $dir ("administrator", "cache", "components", "images", "language",
                 "mambots", "media", "modules", "templates", "plugins") {
	&make_file_php_writable($d, "$opts->{'dir'}/$dir", 0, 0);
	}

if (!$upgrade) { 
	eval "use Digest::MD5";
	local $md5;
	if (!$@) {
		$md5 = Digest::MD5::md5_hex($dompass);
		}

	# Run the SQL setup script and set the prefix
	local @outLines;
	if ($dbtype eq "mysql") {
		# Load the joomla.sql file data for writting the prefix
		&require_mysql();
		local $sqlfile = $version >= 1.5 ?
			"$opts->{'dir'}/installation/sql/mysql/joomla.sql" :
			"$opts->{'dir'}/installation/sql/joomla.sql";
		&open_readfile_as_domain_user($d, FILE, $sqlfile) ||
			return (-1, "Cannot open file $sqlfile : $!");
		while ( $line = <FILE>){
			$line =~ s/#_/jos/g;
			push(@outLines, $line);
			}
		&close_readfile_as_domain_user($d, FILE);

		# Load the sample_data.sql files for writting the prefix
		if ($opts->{'sample'}) {
			local $sqldatafile = "$opts->{'dir'}/installation/sql/".
					     "mysql/sample_data.sql";
			&open_readfile_as_domain_user($d, FILE, $sqldatafile);
			while ( $line = <FILE>){
				$line=~ s/#_/jos/g;
				push(@outLines, $line);
				}
			&close_readfile_as_domain_user($d, FILE);
			local $sqldatafile = "$opts->{'dir'}/installation/sql/".
					     "sample_data.sql";
			&open_readfile_as_domain_user($d, FILE, $sqldatafile);
			while ( $line = <FILE>){
				$line=~ s/#_/jos/g;
				push(@outLines, $line);
				}
			&close_readfile_as_domain_user($d, FILE);
			}

		# Combine the SQL, including the admin user account
		local $combinedfile = &transname();
		open ( OUTFILE, ">$combinedfile" );
		print ( OUTFILE @outLines );
		if ($ver < 1.6) {
			print OUTFILE "INSERT INTO `jos_users` VALUES (62, 'Administrator', '$domuser', '$d->{'emailto_addr'}', '$md5', 'Super Administrator', 0, 1, 25, '2005-09-28 00:00:00', '2005-09-28 00:00:00', '', '');\n";
			print OUTFILE "INSERT INTO `jos_core_acl_aro` VALUES (10,'users','62',0,'Administrator',0);\n";
			print OUTFILE "INSERT INTO `jos_core_acl_groups_aro_map` VALUES (25,'',10);\n";
			}
		elsif ($ver < 2.5) {
			print OUTFILE "INSERT INTO `jos_users` VALUES (62, 'Administrator', '$domuser', '$d->{'emailto_addr'}', '$md5', 'Super Administrator', 0, 1, '2005-09-28 00:00:00', '2005-09-28 00:00:00', '', '');\n";
			print OUTFILE "INSERT INTO `jos_user_usergroup_map` VALUES (62,8);\n";
			}
		elsif ($ver < 3.0) {
			print OUTFILE "INSERT INTO `jos_users` VALUES (62, 'Administrator', '$domuser', '$d->{'emailto_addr'}', '$md5', 'Super Administrator', 0, 1, '2005-09-28 00:00:00', '2005-09-28 00:00:00', '', '', '2005-09-28 00:00:00', 0);\n";
			print OUTFILE "INSERT INTO `jos_user_usergroup_map` VALUES (62,8);\n";
			}
		else {
			print OUTFILE "INSERT INTO `jos_users` VALUES (62, 'Administrator', '$domuser', '$d->{'emailto_addr'}', '$md5', 0, 1, '2005-09-28 00:00:00', '2005-09-28 00:00:00', '', '', '2005-09-28 00:00:00', 0, '', '');\n";
			print OUTFILE "INSERT INTO `jos_user_usergroup_map` VALUES (62,8);\n";
			}
		close ( OUTFILE );
		&require_mysql();
		($ex, $out) = &mysql::execute_sql_file($dbname, $combinedfile,
						       $dbuser, $dbpass);
		$ex && return (-1, "Failed to run database setup script : <tt>$out</tt>.");
                }
	elsif ($dbtype eq "postgres") {
		# Load the joomla.sql file data for writting the prefix
		&require_postgres();
		local $sqlfile = "$opts->{'dir'}/installation/sql/joomla.sql";
		&open_readfile_as_domain_user($d, FILE, $sqlfile) ||
                        return (-1, "Cannot open file $sqlfile : $!");
		while ( $line = <FILE>){
			$line=~ s/#_/jos/g;
			push(@outLines, $line);
			}
		&close_readfile_as_domain_user($d, FILE);
		# Load the sample_data.sql file for writting the prefix
        	local $sqldatafile = "$opts->{'dir'}/installation/sql/sample_data.sql";
		# Append the default user data to the sample_data file
		open(DAT,">>$sqldatafile") ||
			return (-1, "Cannot write to file $sqldatafile : $!");
		if ($ver < 1.6) {
			print DAT "INSERT INTO `#__users` VALUES (62, 'Administrator', '$domuser', '$d->{'emailto_addr'}', '$md5', 'Super Administrator', 0, 1, '2005-09-28 00:00:00', '2005-09-28 00:00:00', '', '');\n";
			print DAT "INSERT INTO `#__core_acl_aro` VALUES (10,'users','62',0,'Administrator',0);\n";
			print DAT "INSERT INTO `#__core_acl_groups_aro_map` VALUES (25,'',10);\n";
			}
		else {
			print DAT "INSERT INTO `#__users` VALUES (62, 'Administrator', '$domuser', '$d->{'emailto_addr'}', '$md5', 'Super Administrator', 0, 1, '2005-09-28 00:00:00', '2005-09-28 00:00:00', '', '');\n";
			print OUTFILE "INSERT INTO `#__user_usergroup_map` VALUES (62,8);\n";
			}
		close (DAT);
		# Write the data to sample_data.sql and create the database,
		# tables, and load the data
		&open_readfile_as_domain_user($d, FILE, $sqldatafile) ||
                        return (-1, "Cannot open file $sqldatafile : $!");
		while ( $line = <FILE>){
			$line=~ s/#_/jos/g;
			push(@outLines, $line);
			}
		&close_readfile_as_domain_user($d, FILE);
		open ( OUTFILE, ">$sqldatafile" );
		print ( OUTFILE @outLines );
		close ( OUTFILE );
		&require_postgres();
		($ex, $out) = &postgresql::execute_sql_file($dbname, $sqldatafile, $dbuser, $dbpass);
		$ex && return (-1, "Failed to run database setup script : <tt>$out</tt>.");
                }
	}

# Remove the installation directory and files.
&unlink_file_as_domain_user($d, "$opts->{'dir'}/installation");
 
# Return a URL for the user
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
local $adminurl = $url."administrator/";
return (1, "Joomla installation complete. Go to <a target=_blank href='$adminurl'>$adminurl</a> to manage it.", "Under $rp", $url, $domuser, $dompass);
}

# script_joomla_uninstall(&domain, version, &opts)
# Un-installs a joomla installation, by deleting the directory.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_joomla_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all jos_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "jos_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "Joomla directory and tables deleted.");
}

# script_joomla_latest(version)
# Returns a URL and regular expression or callback func to get the version
sub script_joomla_latest
{
local ($ver) = @_;
if ($ver >= 3.0) {
	return ( "http://joomlacode.org/gf/project/joomla/frs/",
		 "Joomla(3\\.[0-9\\.]*)<" );
	}
elsif ($ver >= 2.5) {
	return ( "http://joomlacode.org/gf/project/joomla/frs/",
		 "Joomla(2\\.[0-9\\.]*)<" );
	}
elsif ($ver >= 1.6) {
	return ( );
	}
elsif ($ver >= 1.5) {
	return ( "http://joomlacode.org/gf/project/joomla/frs/",
		 "Joomla(1\\.[5][0-9\\.]*)<" );
	}
else {
	return ( );
	}
}

sub script_joomla_site
{
return 'http://joomlacode.org/';
}

sub script_joomla_passmode
{
return 1;
}

# script_joomla_realversion(&domain, &opts)
# Returns the real version number of some script install, or undef if unknown
sub script_joomla_realversion
{
local ($d, $opts, $sinfo) = @_;
foreach my $f ("$opts->{'dir'}/libraries/joomla/version.php",
	       "$opts->{'dir'}/includes/version.php",
	       "$opts->{'dir'}/libraries/cms/version/version.php") {
	local $lref = &read_file_lines($f, 1);
	local ($rel, $dev);
	foreach my $l (@$lref) {
		if ($l =~ /(var|public)\s+\$RELEASE\s+=\s+'([0-9\.]+)'/) {
			$rel = $2;
			}
		elsif ($l =~ /(var|public)\s+\$DEV_LEVEL\s+=\s+'([0-9\.]+)'/) {
			$dev = $2;
			}
		}
	if ($rel) {
		$rel .= ".".$dev;
		return $rel;
		}
	}
return undef;
}

1;

