
# script_mantis_desc()
sub script_mantis_desc
{
return "Mantis";
}

sub script_mantis_uses
{
return ( "php" );
}

sub script_mantis_longdesc
{
return "Mantis is a free popular web-based bugtracking system.";
}

# script_mantis_versions()
sub script_mantis_versions
{
return ( "1.2.17" );
}

sub script_mantis_category
{
return "Tracker";
}

sub script_mantis_php_vers
{
return ( 5 );
}

sub script_mantis_php_modules
{
return ("mysql");
}

sub script_mantis_perl_modules
{
return ( "Digest::MD5" );
}

sub script_mantis_dbs
{
return ("mysql");
}

# script_mantis_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_mantis_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for Mantis tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for Mantis tables",
		     &ui_database_select("db", undef, \@dbs, $d, "mantis"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("mantis", $d), 30, "At top level"));
	}
return $rv;
}

# script_mantis_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_mantis_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_mantis_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_mantis_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/index.php") {
	return "Mantis appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "mantis_.*");
$clash && return "Mantis appears to be already using the selected database (table $clash)";
return undef;
}

# script_mantis_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_mantis_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "mantis-$ver.zip",
	   'url' => "http://prdownloads.sourceforge.net/mantisbt/mantisbt-$ver.tar.gz" } );
return @files;
}

sub script_mantis_commands
{
return ("tar", "gunzip");
}

# script_mantis_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Mantis, and returns either 1 and an informational
# message, or 0 and an error
sub script_mantis_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "mantisbt-$ver");
$err && return (0, "Failed to extract source : $err");
local $cfileorig = "$opts->{'dir'}/config_inc.php.sample";

local $url = &script_path_url($d, $opts);
if (!$upgrade) {
	# Make dir writable
	&make_file_php_writable($d, $opts->{'dir'}, 1);

	# Trigger the installation PHP script
	local @params = (
		[ "db_type", "mysql" ],
		[ "hostname", $dbhost ],
		[ "db_username", $dbuser ],
		[ "db_password", $dbpass ],
		[ "database_name", $dbname ],
		[ "admin_username", $domuser ],
		[ "admin_password", $dompass ],
		[ "go", "Install/Upgrade Database" ],
		[ "install", 2 ]
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/admin/install.php";

	# Make an HTTP post to the installer page
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "Mantis post-install configuration failed : $ierror");
		}

	# Change administrator login
	eval "use Digest::MD5";
	local $md5;
	if (!$@) {
		$md5 = Digest::MD5::md5_hex($dompass);
		}
	&require_mysql();
	eval {
		local $main::error_must_die = 1;
		&mysql::execute_sql($dbname,
			"update mantis_user_table set username = ?, ".
			  "email = ?, password = ? where id = 1",
			$domuser, $d->{'emailto_addr'}, $md5);
		};
	if ($@) {
		return (-1, "Admin user update failed : $@");
		}
	}

# Delete the admin directory
&run_as_domain_user($d, "rm -rf ".quotemeta("$opts->{'dir'}/admin"));

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Mantis installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.", "Under $rp using $dbphptype database $dbname", $url, $domuser, $dompass);
}

# script_mantis_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_mantis_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all mantis_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "mantis_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "Mantis directory and tables deleted.");
}

# script_mantis_check_latest(version)
# Checks if some version is the latest for this project, and if not returns
# a newer one. Otherwise returns undef.
sub script_mantis_check_latest
{
local ($ver) = @_;
local @vers = &osdn_package_versions("mantisbt",
				     "mantisbt-([0-9\\.]+)\\.tar\\.gz");
return "Failed to find versions" if (!@vers);
return $ver eq $vers[0] ? undef : $vers[0];
}

sub script_mantis_site
{
return 'http://www.mantisbt.org/';
}

sub script_mantis_passmode
{
return 1;
}

1;

