
# script_osticket_desc()
sub script_osticket_desc
{
return "osTicket";
}

sub script_osticket_uses
{
return ( "php" );
}

sub script_osticket_longdesc
{
return "osTicket is a widely-used open source support ticket system.";
}

# script_osticket_versions()
sub script_osticket_versions
{
return ( "1.6.0" );
}

sub script_osticket_php_vers
{
return ( 5 );
}

sub script_osticket_php_modules
{
return ("mysql");
}

sub script_osticket_dbs
{
return ("mysql");
}

# script_osticket_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_osticket_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for osTicket tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	$rv .= &ui_table_row("Title for helpdesk",
			     $upgrade->{'opts'}->{'title'});
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for osTicket tables",
		     &ui_database_select("db", undef, \@dbs, $d, "osticket"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("osticket", $d), 30, "At top level"));
	$rv .= &ui_table_row("Title for helpdesk",
			     &ui_textbox("title", "$d->{'owner'} helpdesk",30));
	}
return $rv;
}

# script_osticket_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_osticket_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'title' => $in->{'title'},
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_osticket_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_osticket_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/admin.php") {
	return "osTicket appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "ost_.*");
$clash && return "osTicket appears to be already using the selected database (table $clash)";
$opts->{'title'} ||= "$d->{'owner'} helpdesk";
return undef;
}

# script_osticket_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_osticket_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "osticket_$ver.zip",
	   'url' => "http://osticket.com/dl/osticket_$ver.tar.gz" } );
return @files;
}

sub script_osticket_commands
{
return ("tar", "gunzip");
}

# script_osticket_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs osTicket, and returns either 1 and an informational
# message, or 0 and an error
sub script_osticket_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);

# Setup and get DB
if ($opts->{'newdb'} && !$upgrade) {
	local $err = &create_script_database($d, $opts->{'db'});
	return (0, "Database creation failed : $err") if ($err);
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Preserve old config file
local $cfile = "$opts->{'dir'}/include/ost-config.php";
local $cfilesrc = "$opts->{'dir'}/include/ost-config.sameple.php";
local $oldcfile = &transname();
if ($upgrade) {
	if (-r $cfile) {
		&copy_source_dest($cfile, $oldcfile);
		}
	elsif (-r "$opts->{'dir'}/ostconfig.php") {
		# Older version config file
		&copy_source_dest("$opts->{'dir'}/ostconfig.php", $oldcfile);
		}
	elsif (-r "$opts->{'dir'}/config.php") {
		# Way older version config file
		&copy_source_dest("$opts->{'dir'}/config.php", $oldcfile);
		}
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "osticket_$ver/upload");
$err && return (0, "Failed to extract source : $err");

if (!$upgrade) {
	# Copy in sample config file
	&copy_source_dest_as_domain_user($d, $cfilesrc, $cfile);
	}
&make_file_php_writable($d, $cfile);
local $url = &script_path_url($d, $opts);

if ($upgrade) {
	# Put back original config file
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	}
else {
	# Create parameters for the installer URL
	&foreign_require("mailboxes", "mailboxes-lib.pl");
	if (length($dompass) < 6) {
		$dompass .= "123456";
		}
	local @params = (
	    [ "title", $opts->{'title'} ],
	    [ "url", $url ],
	    [ "sysemail", &get_global_from_address($d) ],
	    [ "username", $domuser ],
	    [ "password", $dompass ],
	    [ "password2", $dompass ],
	    [ "email", $d->{'emailto_addr'} ],
	    [ "prefix", "ost_" ],
	    [ "dbhost", $dbhost ],
	    [ "dbname", $dbname ],
	    [ "dbuser", $dbuser ],
	    [ "dbpass", $dbpass ],
	    );
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/setup/index.php";

	# Make an HTTP post to the installer page
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "osTicket configuration failed : $ierror");
		}
	elsif ($iout !~ /Post-Install\s+Setup/i) {
		return (-1, "osTicket configuration failed");
		}
	}

# Return a URL for the user
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
local $adminurl = $url."scp/index.php";
return (1, "osTicket installation complete. It can be configured at <a target=_blank href='$adminurl'>$adminurl</a>.", "Under $rp using $dbphptype database $dbname", $url, $domuser, $dompass);
}

# script_osticket_uninstall(&domain, version, &opts)
# Un-installs an osTicket installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_osticket_uninstall
{
local ($d, $version, $opts) = @_;

# Remove all ost_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "ost_");

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Take out the DB
if ($opts->{'newdb'}) {
	&delete_script_database($d, $opts->{'db'});
	}

return (1, "osTicket directory and tables deleted.");
}

# script_osticket_latest(version)
# Returns a URL and regular expression or callback func to get the version
sub script_osticket_latest
{
local ($ver) = @_;
return ( "http://osticket.com/downloads.php",
	 "osTicket ([0-9a-z\\.]+)" );
}

sub script_osticket_site
{
return 'http://osticket.com/';
}

sub script_osticket_passmode
{
return 1;
}

1;

