
# script_phpcoin_desc()
sub script_phpcoin_desc
{
return "PHPCoin";
}

sub script_phpcoin_uses
{
return ( "php" );
}

sub script_phpcoin_longdesc
{
return "The phpCOIN (Clients, Order, Invoices, and Notes) package was designed for small to medium sized webhosting resellers.";
}

# script_phpcoin_versions()
sub script_phpcoin_versions
{
return ( "v1.6.5" );
}

sub  script_phpcoin_version_desc
{
local ($ver) = @_;
$ver =~ s/_full.*$//;
return $ver;
}

sub script_phpcoin_category
{
return "Commerce";
}

sub script_phpcoin_php_vers
{
return ( 4, 5 );
}

sub script_phpcoin_php_modules
{
local ($d, $ver, $phpver, $opts) = @_;
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
return $dbtype eq "mysql" ? ("mysql") : ("pgsql");
}

sub script_phpcoin_dbs
{
return ("mysql", "postgres");
}

# script_phpcoin_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_phpcoin_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for PHPCoin tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql", "postgres" ]);
	$rv .= &ui_table_row("Database for PHPCoin tables",
		     &ui_database_select("db", undef, \@dbs, $d, "phpcoin"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("phpcoin", $d), 30, "At top level"));
	}
return $rv;
}

# script_phpcoin_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_phpcoin_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_phpcoin_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_phpcoin_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/config.php") {
	return "PHPCoin appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "phpcoin_.*");
$clash && return "PHPCoin appears to be already using the selected database (table $clash)";
return undef;
}

# script_phpcoin_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_phpcoin_files
{
local ($d, $ver, $opts, $upgrade) = @_;
$ver =~ s/\.//g;
local @files = ( { 'name' => "source",
	   'file' => "phpcoin_$ver.zip",
	   'referer' => 'http://phpcoin.com/mod.php?mod=downloads',
	   'nocheck' => 1,
	   'url' => "http://www.phpcoin.com/downloads/phpcoin_${ver}_full_2009-09-26.zip" } );
return @files;
}

sub script_phpcoin_commands
{
return ("unzip");
}

# script_phpcoin_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs PHPCoin, and returns either 1 and an informational
# message, or 0 and an error
sub script_phpcoin_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "psql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, undef);
$err && return (0, "Failed to extract source : $err");
local $cfile = "$opts->{'dir'}/config.php";

# Update the config file
local $lref = &read_file_lines_as_domain_user($d, $cfile);
local $l;
foreach $l (@$lref) {
	if ($l =~ /^\s*\$_DBCFG\['dbms'\]\s*=/) {
		$l = "\$_DBCFG['dbms'] = \"$dbphptype\";";
		}
	if ($l =~ /^\s*\$_DBCFG\['dbuname'\]\s*=/) {
		$l = "\$_DBCFG['dbuname'] = \"$dbuser\";";
		}
	if ($l =~ /^\s*\$_DBCFG\['dbpass'\]\s*=/) {
		$l = "\$_DBCFG['dbpass'] = \"".&php_quotemeta($dbpass)."\";";
		}
	if ($l =~ /^\s*\$_DBCFG\['dbname'\]\s*=/) {
		$l = "\$_DBCFG['dbname'] = \"$dbname\";";
		}
	if ($l =~ /^\s*\$_DBCFG\['dbhost'\]\s*=/) {
		$l = "\$_DBCFG['dbhost'] = \"$dbhost\";";
		}
	if ($l =~ /^\s*\$_SMTP\['HOST'\]\s*=/) {
		$l = "\$_SMTP['HOST'] = \"localhost\";";
		}
	if ($l =~ /^\s*\$_SMTP\['LOCALHOST'\]\s*=/) {
		$l = "\$_SMTP['LOCALHOST'] = \"$d->{'dom'}\";";
		}
	if ($l =~ /^\s*\$_SMTP\['ACC'\]\s*=/) {
		$l = "\$_SMTP['ACC'] = \"$d->{'emailto_addr'}\";";
		}
	}
&flush_file_lines_as_domain_user($d, $cfile);

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "PHPCoin installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.", "Under $rp using $dbphptype database $dbname", $url, "webmaster", $dbpass);
}

# script_phpcoin_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_phpcoin_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all wp_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "phpcoin_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "PHPCoin directory and tables deleted.");
}

# script_phpcoin_latest()
# Returns a URL and regular expression or callback func to get the version
#sub script_phpcoin_latest
#{
#return ( "https://www.phpcoin.com/mod.php?mod=downloads",
#	 \&script_phpcoin_callback );
#}

sub script_phpcoin_callback
{
local ($data) = @_;
if ($data =~ /Current\s+Version:\s+v(\d+)\.(\d+)\.(\d+)/) {
	return "v$1$2$3";
	}
elsif ($data =~ /Current\s+Release:.*phpCOIN\s+v(\d+)\.(\d+)\.(\d+)/) {
	return "v$1$2$3";
	}
elsif ($data =~ /phpCOIN\s+(v(\d+)\.(\d+)\.(\d+))/) {
	return $1;
	}
return ( );
}

sub script_phpcoin_site
{
return 'http://phpcoin.com/';
}

1;

