
# script_phpledmailer_desc()
sub script_phpledmailer_desc
{
return "phpLedMailer";
}

sub script_phpledmailer_uses
{
return ( "php" );
}

sub script_phpledmailer_longdesc
{
return "phpLedMailer is a simple, cool, easy-to-use single-mailing-list application";
}

# script_phpledmailer_versions()
sub script_phpledmailer_versions
{
return ( "1.8" );
}

sub script_phpledmailer_category
{
return "Email";
}

sub script_phpledmailer_php_vers
{
return ( 4, 5 );
}

sub script_phpledmailer_php_modules
{
return ("mysql");
}

sub script_phpledmailer_dbs
{
return ("mysql");
}

# script_phpledmailer_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_phpledmailer_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for phpLedMailer tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for phpLedMailer tables",
		     &ui_database_select("db", undef, \@dbs, $d, "phpledmailer"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("phpledmailer", $d), 30, "At top level"));
	}
return $rv;
}

# script_phpledmailer_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_phpledmailer_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_phpledmailer_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_phpledmailer_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/config.inc.php") {
	return "phpLedMailer appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "plm_.*");
$clash && return "phpLedMailer appears to be already using the selected database (table $clash)";
return undef;
}

# script_phpledmailer_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_phpledmailer_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "phpLedMailer-$ver.zip",
	   'url' => "http://www.ledscripts.com/download?file=phpLedMailer-1.8.zip" } );
return @files;
}

sub script_phpledmailer_commands
{
return ("unzip");
}

# script_phpledmailer_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs phpLedMailer, and returns either 1 and an informational
# message, or 0 and an error
sub script_phpledmailer_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "psql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Save old config file
local $cfile = "$opts->{'dir'}/config.inc.php";
local $cfileold = &transname();
if ($upgrade) {
	&copy_source_dest($cfile, $cfileold);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
			     $opts->{'dir'}, "phpLedMailer-$ver");
$err && return (0, "Failed to extract source : $err");

if ($upgrade) {
	# Put config file backup
	&copy_source_dest_as_domain_user($d, $cfileold, $cile);
	}
else {
	# Make a config file
	my $qdbpass = &php_quotemeta($dbpass);
	&open_tempfile_as_domain_user($d, CFILE, ">$cfile", 0, 1);
	&print_tempfile(CFILE, <<EOF
<?
\$config = array(
        'db'    => array(
                'type'  => 'mysqlt',
                'host'  => '$dbhost',
                'user'  => '$dbuser',
                'pass'  => '$qdbpass',
                'db'    => '$dbname' // your database
        )
);
?>
EOF
	);
	&close_tempfile_as_domain_user($d, CFILE);
	&make_file_php_writable($d, $cfile);

	# Call the install URL
	local @params = (
		[ "username", $domuser ],
		[ "password", $dompass ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install.php";
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "phpLedMailer configuration failed : $ierror");
		}
	elsif ($iout !~ /Installation\s+is\s+now\s+complete/i) {
		return (-1, "phpLedMailer configuration failed");
		}
	}

# Delete the install script
&unlink_file_as_domain_user($d, "$opts->{'dir'}/install.php");
&unlink_file_as_domain_user($d, "$opts->{'dir'}/.cvsignore");

# Make upload directories writable
&make_file_php_writable($d, "$opts->{'dir'}/misc", 1);
&make_file_php_writable($d, "$opts->{'dir'}/misc/userfiles", 1);

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $adminurl = $url."admin.php?mod=config";
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "phpLedMailer installation complete. It can be managed at <a target=_blank href='$adminurl'>$adminurl</a>.", "Under $rp using $dbphptype database $dbname", $url, $domuser, $dompass);
}

# script_phpledmailer_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_phpledmailer_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all phpledmailer_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "plm_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "phpLedMailer directory and tables deleted.");
}

# script_phpledmailer_latest(version)
# Returns a URL and regular expression or callback func to get the version
# Site appears to be down
#sub script_phpledmailer_latest
#{
#local ($ver) = @_;
#return ( "http://www.ledscripts.com/free/php/phpledmailer",
#	 "phpLedMailer\\s+v([0-9\\.]+)" );
#}

sub script_phpledmailer_site
{
return 'http://www.ledscripts.com/free/php/phpledmailer';
}

sub script_phpledmailer_passmode
{
return 1;
}

sub script_phpledmailer_abandoned
{
return 1;	# Site appears to be down
}

1;

