
# script_phpmyfaq_desc()
sub script_phpmyfaq_desc
{
return "phpMyFAQ";
}

sub script_phpmyfaq_uses
{
return ( "php" );
}

sub script_phpmyfaq_longdesc
{
return "phpMyFAQ is an open source FAQ system using PHP.";
}

# script_phpmyfaq_versions()
sub script_phpmyfaq_versions
{
return ( "2.8.9" );
}

sub script_phpmyfaq_category
{
return "Helpdesk";
}

sub script_phpmyfaq_php_vers
{
return ( 5 );
}

sub script_phpmyfaq_php_modules
{
local ($d, $ver, $phpver, $opts) = @_;
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
return $dbtype eq "mysql" ? ("mysql") : ("pgsql");
}

sub script_phpmyfaq_dbs
{
return ("mysql", "postgres", "zip");
}

# script_phpmyfaq_depends(&domain, version)
sub script_phpmyfaq_depends
{
local ($d, $ver, $sinfo, $phpver) = @_;
local @rv;

if ($ver >= 2.8) {
	# Check for PHP 5.3+
	local $phpv = &get_php_version($phpver || 5, $d);
	if (!$phpv) {
		push(@rv, "Could not work out exact PHP version");
		}
	elsif ($phpv < 5.3) {
		push(@rv, "phpMyFAQ requires PHP version 5.3 or later");
		}
	}

return @rv;
}

# script_phpmyfaq_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_phpmyfaq_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for phpMyFAQ tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql", "postgres" ]);
	$rv .= &ui_table_row("Database for phpMyFAQ tables",
		     &ui_database_select("db", undef, \@dbs, $d, "phpmyfaq"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("faq", $d), 30, "At top level"));
	}
return $rv;
}

# script_phpmyfaq_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_phpmyfaq_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_phpmyfaq_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_phpmyfaq_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/data.php") {
	return "phpMyFAQ appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "phpmyfaq_.*");
$clash && return "phpMyFAQ appears to be already using the selected database (table $clash)";
return undef;
}

# script_phpmyfaq_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_phpmyfaq_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "phpmyfaq-$ver.zip",
	   'url' => "http://www.phpmyfaq.de/getfaq.php?number=$ver&ext=.zip" } );
return @files;
}

sub script_phpmyfaq_commands
{
return ("unzip");
}

# script_phpmyfaq_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs phpMyFAQ, and returns either 1 and an informational
# message, or 0 and an error
sub script_phpmyfaq_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbhost = &get_database_host($dbtype); 
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
			     $opts->{'dir'}, "phpmyfaq*");
$err && return (0, "Failed to extract source : $err");
local $cfile = "$opts->{'dir'}/data.php";

# Make needed files writable
foreach my $dir ("attachments", "data", "images", "pdf", "xml") {
	local $path = "$opts->{'dir'}/$dir";
	if (!-d $path) {
		&make_dir_as_domain_user($d, $path, 0755);
		}
	&make_file_php_writable($d, $path);
	}

if (!$upgrade) {
	# Copy the template config file
	local $cfilesrc = "$opts->{'dir'}/inc/data.php";
	&copy_source_dest_as_domain_user($d, $cfilesrc, $cfile);
	&make_file_php_writable($d, $cfile);

	# Make password longer
	if (length($dompass) < 6) {
		$dompass .= "123456";
		}

	# Call the install URL
	local @params = (
		[ "sql_type", $dbtype eq "mysql" ? "mysql" : "pgsql" ],
		[ "sql_server", $dbhost ],
		[ "sql_user", $dbuser ],
		[ "sql_passwort", $dbpass ],
		[ "sql_db", $dbname ],
		[ "sqltblpre", "phpmyfaq_" ],
		[ "language", "language_en.php" ],
		[ "permLevel", "basic" ],
		[ "realname", $d->{'owner'} ],
		[ "email", $d->{'emailto_addr'} ],
		[ "loginname", $domuser ],
		[ "password", $dompass ],
		[ "password_retyped", $dompass ]
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install/setup.php";
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "Installation URL failed : $ierror");
		}
	elsif ($iout !~ /successfully\s+created|Congratulation|worked\s+like\s+a\s+charm/i) {
		return (-1, "Installation URL failed");
		}
	}

# Return a URL for the user
local $userurl = &script_path_url($d, $opts);
local $url = $upgrade ? $userurl."install/update.php"
		      : $userurl."admin/index.php";
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "phpMyFAQ installation complete. It can be managed at <a target=_blank href='$url'>$url</a>.", "Under $rp using $dbphptype database $dbname", $userurl, "admin", $dompass);
}

# script_phpmyfaq_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_phpmyfaq_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all faw tables from the database
&cleanup_script_database($d, $opts->{'db'}, "phpmyfaq_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "phpMyFAQ directory and tables deleted.");
}

# script_phpmyfaq_latest(version)
# Returns a URL and regular expression or callback func to get the version
sub script_phpmyfaq_latest
{
local ($ver) = @_;
return ( "http://www.phpmyfaq.de/",
	 "Download phpMyFAQ ([0-9\\.]+) " );
}

sub script_phpmyfaq_site
{
return 'http://www.phpmyfaq.de/';
}

sub script_phpmyfaq_passmode
{
return 1;
}

1;

