
@phpscheduleit_tables = (
	"announcements",
	"login",
	"reservations",
	"resources",
	"permission",
	"schedules",
	"schedule_permission",
	"reservation_users",
	"anonymous_users",
	"additional_resources",
	"reservation_resources",
	"mutex",
	"groups",
	"user_groups",
	"reminders",
	"accessories",
	"account_activation",
	"blackout_instances",
	"blackout_series",
	"custom_attribute_values",
	"custom_attributes",
	"dbversion",
	"group_resource_permissions",
	"group_roles",
	"groups",
	"layouts",
	"quotas",
	"reservation_accessories",
	"reservation_files",
	"reservation_instances",
	"reservation_series",
	"reservation_statuses",
	"reservation_types",
	"resources",
	"roles",
	"saved_reports",
	"schedules",
	"time_blocks",
	"user_email_preferences",
	"user_resource_permissions",
	"user_statuses",
	"users",
	"reservation_reminders",
	"reservation_series",
	"reservation_statuses",
	"reservation_types",
	"user_session",
	"user_statuses",
	"users",
	);

# script_phpscheduleit_desc()
sub script_phpscheduleit_desc
{
return "phpScheduleIt";
}

sub script_phpscheduleit_uses
{
return ( "php" );
}

sub script_phpscheduleit_longdesc
{
return "A web-based resource scheduling system that allows administered management of reservations on any number of resources, such as conference rooms.";
}

# script_phpscheduleit_versions()
sub script_phpscheduleit_versions
{
return ( "2.4.2" );
}

sub script_phpscheduleit_can_upgrade
{
local ($sinfo, $newver) = @_;
if ($newver >= 2 && $sinfo->{'version'} < 2) {
	# Cannot upgrade 1.x to 2.x
	return 0;
	}
return 1;
}

sub script_phpscheduleit_category
{
return "Calendar";
}

sub script_phpscheduleit_php_vers
{
return ( 5 );
}

sub script_phpscheduleit_pear_modules
{
return ("DB");
}

sub script_phpscheduleit_php_modules
{
local ($d, $ver, $phpver, $opts) = @_;
return ( "mysql" );
}

sub script_phpscheduleit_dbs
{
return ("mysql");
}

# script_phpscheduleit_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_phpscheduleit_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for phpScheduleIt tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for phpScheduleIt tables",
		     &ui_database_select("db", undef, \@dbs, $d,
					 "phpscheduleit"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("phpscheduleit", $d), 30, "At top level"));
	}
return $rv;
}

# script_phpscheduleit_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_phpscheduleit_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_phpscheduleit_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_phpscheduleit_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/index.php") {
	return "phpScheduleIt appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
foreach my $t (@phpscheduleit_tables) {
	local $clash = &find_database_table($dbtype, $dbname, $t);
	$clash && return "phpScheduleIt appears to be already using the selected database (table $clash)";
	}
return undef;
}

# script_phpscheduleit_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by PHP-Nuke, each of which is a hash ref
# containing a name, filename and URL
sub script_phpscheduleit_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "phpScheduleIt_$ver.zip",
	   'url' => "http://osdn.dl.sourceforge.net/sourceforge/phpscheduleit/phpScheduleIt-$ver.zip" } );
return @files;
}

sub script_phpscheduleit_commands
{
return ("unzip");
}

# script_phpscheduleit_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs phpScheduleIt, and returns either 1 and an informational
# message, or 0 and an error
sub script_phpscheduleit_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "postgresql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "phpScheduleIt");
$err && return (0, "Failed to extract source : $err");
local $cfile = "$opts->{'dir'}/config/config.php";
local $cfileorig = "$opts->{'dir'}/config/config.dist.php";

local $url = &script_path_url($d, $opts)."Web";
if (!$upgrade) {
	# Copy and fix the config file
	&copy_source_dest_as_domain_user($d, $cfileorig, $cfile);
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	foreach $l (@$lref) {
		if ($l =~ /\$conf\['settings'\]\['script.url'\] =/) {
			$l = "\$conf['settings']['script.url'] = '${url}';";
			}
		if ($l =~ /\$conf\['settings'\]\['admin.email'\] =/) {
			$l = "\$conf['settings']['admin.email'] = '$d->{'emailto_addr'}';";
			}
		if ($l =~ /\$conf\['settings'\]\['phpmailer'\]\['mailer'\] =/) {
			$l = "\$conf['settings']['phpmailer']['mailer'] = 'smtp';";
			}
		if ($l =~ /\$conf\['settings'\]\['phpmailer'\]\['smtp.host'\] =/) {
			$l = "\$conf['settings']['phpmailer']['smtp.host'] = 'localhost';";
			}
		if ($l =~ /\$conf\['settings'\]\['database'\]\['type'\] =/) {
			$l = "\$conf['settings']['database']['type'] = 'mysql';";
			}
		if ($l =~ /\$conf\['settings'\]\['database'\]\['user'\] =/) {
			$l = "\$conf['settings']['database']['user'] = '$dbuser';";
			}
		if ($l =~ /\$conf\['settings'\]\['database'\]\['password'\] =/) {
			$l = "\$conf['settings']['database']['password'] = '".
			     &php_quotemeta($dbpass)."';";
			}
		if ($l =~ /\$conf\['settings'\]\['database'\]\['name'\] =/) {
			$l = "\$conf['settings']['database']['name'] = '$dbname';";
			}
		if ($l =~ /\$conf\['settings'\]\['database'\]\['hostspec'\] =/) {
			$l = "\$conf['settings']['database']['hostspec'] = '$dbhost';";
			}
		if ($l =~ /\$conf\['settings'\]\['install.password'\] =/) {
			$l = "\$conf['settings']['install.password'] = '$dompass';";
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);
	&make_file_php_writable($d, $cfile);

	# Run the setup SQL
	local $sqlfile = "$opts->{'dir'}/database_schema/full-install.sql";
	local $lref = &read_file_lines_as_domain_user($d, $sqlfile);
	foreach my $l (@$lref) {
		if ($l =~ /^(drop\s+database|create\s+database|use|grant|on|to)\s/i) {
			$l = "";	# Remove DB creation lines
			}
		}
	&flush_file_lines_as_domain_user($d, $sqlfile);
	&require_mysql();
	($ex, $out) = &mysql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
	$ex && return (-1, "Failed to run database setup script : <tt>$out</tt>.");

	# Run the user creation SQL
	local $sqlfile = "$opts->{'dir'}/database_schema/sample-data-utf8.sql";
	($ex, $out) = &mysql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
	$ex && return (-1, "Failed to run user creation script : <tt>$out</tt>.");
	}

# Return a URL for the user
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Initial phpScheduleIt installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>", "Under $rp using $dbphptype database $dbname", $url, "admin", "password");
}

# script_phpscheduleit_uninstall(&domain, version, &opts)
# Un-installs a PHP-Nuke installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_phpscheduleit_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all tables from the database
for(my $i=0; $i<@phpscheduleit_tables; $i++) {
	my $err = &cleanup_script_database($d, $opts->{'db'},
					   \@phpscheduleit_tables);
	last if (!$err);
	}

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "phpScheduleIt directory and tables deleted.");
}

# script_phpscheduleit_php_vars(&domain)
# Returns an array of extra PHP variables needed for this script
sub script_phpscheduleit_php_vars
{
return ( [ 'safe_mode', 'Off' ] );
}

# script_phpscheduleit_check_latest(version)
# Checks if some version is the latest for this project, and if not returns
# a newer one. Otherwise returns undef.
sub script_phpscheduleit_check_latest
{
local ($ver) = @_;
local @vers = &osdn_package_versions("phpscheduleit", "phpScheduleIt-([0-9\\.]+)\\.zip");
return "Failed to find versions" if (!@vers);
return $ver eq $vers[0] ? undef : $vers[0];
}

sub script_phpscheduleit_site
{
return 'http://www.php.brickhost.com/';
}

1;

