
# script_phpwebsite_desc()
sub script_phpwebsite_desc
{
return "phpWebSite";
}

sub script_phpwebsite_uses
{
return ( "php" );
}

sub script_phpwebsite_longdesc
{
return "phpWebSite provides a complete web site content management system.";
}

# script_phpwebsite_versions()
sub script_phpwebsite_versions
{
return ( "1.6.1" );
}

sub script_phpwebsite_category
{
return "Content Management System";
}

sub script_phpwebsite_php_vers
{
return ( 5 );
}

sub script_phpwebsite_php_modules
{
return ("mysql");
}

sub script_phpwebsite_dbs
{
return ("mysql");
}

# script_phpwebsite_php_vars(&domain)
# Returns an array of extra PHP variables needed for this script
sub script_phpwebsite_php_vars
{
return ( [ 'allow_call_time_pass_reference', 'On' ],
	 [ 'magic_quotes_gpc', 'Off' ] );
}

# script_phpwebsite_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHPwebsite
sub script_phpwebsite_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for phpWebSite tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for phpWebSite tables",
		     &ui_database_select("db", undef, \@dbs, $d, "phpwebsite"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("phpwebsite", $d), 30, "At top level"));
	}
return $rv;
}

# script_phpwebsite_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_phpwebsite_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_phpwebsite_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_phpwebsite_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/core/Core.php") {
	return "phpWebSite appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "phpwebsite_.*");
$clash && return "phpWebSite appears to be already using the selected database (table $clash)";
return undef;
}

# script_phpwebsite_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by PHPwebsite, each of which is a hash ref
# containing a name, filename and URL
sub script_phpwebsite_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local $uver = $ver;
$uver =~ s/\./_/g;
local @files = ( { 'name' => "source",
	   'file' => "phpwebsite-$ver-full.tar.gz",
	   'url' => "http://downloads.sourceforge.net/phpwebsite/phpwebsite_$uver.tar.gz" } );
return @files;
}

sub script_phpwebsite_commands
{
return ("tar", "gunzip");
}

# script_phpwebsite_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs phpWebSite, and returns either 1 and an informational
# message, or 0 and an error
sub script_phpwebsite_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $uver = $ver;
$uver =~ s/\./_/g;
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "phpwebsite_$uver");
$err && return (0, "Failed to extract source : $err");

# Create the config file, if needed
local $cfile = "$opts->{'dir'}/config/config.php";
if (!-r $cfile) {
	local $hash;
	for(my $i=0; $i<20; $i++) {
		$hash .= int(rand()*10);
		}
	&open_tempfile_as_domain_user($d, CONF, ">$cfile");
	&print_tempfile(CONF, "<?php\n");
	&print_tempfile(CONF, "\$dbversion = \"mysql\";\n");
	&print_tempfile(CONF, "\$dbhost = \"$dbhost\";\n");
	&print_tempfile(CONF, "\$dbuser = \"$dbuser\";\n");
	&print_tempfile(CONF, "\$dbpass = \"".&php_quotemeta($dbpass)."\";\n");
	&print_tempfile(CONF, "\$dbname = \"$dbname\";\n");
	&print_tempfile(CONF, "\$table_prefix = \"phpwebsite_\";\n");
	&print_tempfile(CONF, "\$source_http = \"$d->{'dom'}$opts->{'path'}\";\n");
	&print_tempfile(CONF, "\$source_dir = \"$opts->{'dir'}/\";\n");
	&print_tempfile(CONF, "\$hub_hash = \"$hash\";\n");
	&print_tempfile(CONF, "\$install_pw = \"$dompass\";\n");
	&print_tempfile(CONF, "?>\n");
	&close_tempfile_as_domain_user($d, CONF);
	&set_permissions_as_domain_user($d, 0777, $cfile);
	}

# Set permissions
&make_file_php_writable($d, "$opts->{'dir'}/images");
&make_file_php_writable($d, "$opts->{'dir'}/files");
&open_tempfile_as_domain_user($d, TOUCH, ">>$opts->{'dir'}/.htaccess", 0, 1);
&close_tempfile_as_domain_user($d, TOUCH);
&make_file_php_writable($d, "$opts->{'dir'}/.htaccess");

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $setupurl = $url."setup";
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Initial phpWebSite installation complete. Go to <a target=_blank href='$setupurl'>$setupurl</a> to complete the setup process.", "Under $rp using $dbphptype database $dbname", $url, undef, $dompass);
}

# script_phpwebsite_uninstall(&domain, version, &opts)
# Un-installs a PHPwebsite installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_phpwebsite_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all phpwebsite_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "phpwebsite_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "phpWebSite directory and tables deleted.");
}

# script_phpwebsite_check_latest(version)
# Checks if some version is the latest for this project, and if not returns
# a newer one. Otherwise returns undef.
# Version 1.6.2 is too hard to support right now
#sub script_phpwebsite_check_latest
#{
#local ($ver) = @_;
#local @vers = &osdn_package_versions("phpwebsite", "phpwebsite_([0-9_]+)\\.tar\\.gz");
#@vers = map { s/\_/\./g; $_ } @vers;
#return "Failed to find versions" if (!@vers);
#return $ver eq $vers[0] ? undef : $vers[0];
#}

sub script_phpwebsite_site
{
return 'http://phpwebsite.appstate.edu/';
}

sub script_phpwebsite_passmode
{
return 2;
}

1;

