
@phpwiki_tables = ( "archive", "hitcount", "hottopics", "wiki",
		    "wikilinks", "wikiscore" );

# script_phpwiki_desc()
sub script_phpwiki_desc
{
return "Php-Wiki";
}

sub script_phpwiki_uses
{
return ( "php" );
}

sub script_phpwiki_longdesc
{
return "A Php-WikiWeb is a web site where anyone can edit the pages through an HTML form.";
}

# script_phpwiki_versions()
sub script_phpwiki_versions
{
return ( "1.4.0rc1", "1.3.14", "1.2.11" );
}

sub script_phpwiki_version_desc
{
local ($ver) = @_;
return $ver < 1.3 ? "$ver (Very old, stable)" :
       $ver < 1.4 ? "$ver (Old development)" :
		    "$ver (Current)";
}

sub script_phpwiki_category
{
return "Wiki";
}

sub script_phpwiki_php_vers
{
return ( 5 );
}

sub script_phpwiki_pear_modules
{
return ("DB");
}

sub script_phpwiki_php_modules
{
return ("dba", "mysql");
}

# script_phpwiki_depends(&domain, version)
sub script_phpwiki_depends
{
local ($d, $ver) = @_;
local $mode = &get_domain_php_mode($d);
if ($mode eq "fcgid") {
	return ("PhpWiki does not work when using fcgid mode for executing PHP scripts");
	}
return ( );
}

# script_phpwiki_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_phpwiki_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for Php-Wiki tables",
			     $dbname || "None");
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql", "postgres" ]);
	$rv .= &ui_table_row("Database for Php-Wiki tables",
		     &ui_select("db", undef,
			[ [ "", "None (Use files only)" ],
			  map { [ $_->{'type'}."_".$_->{'name'},
				  $_->{'name'}." ($_->{'desc'})" ] } @dbs ]));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("phpwiki", $d), 30, "At top level"));
	}
return $rv;
}

# script_phpwiki_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_phpwiki_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	return { 'db' => $in->{'db'},
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_phpwiki_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_phpwiki_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/lib/config.php") {
	return "Php-Wiki appears to be already installed in the selected directory";
	}
if ($opts->{'db'}) {
	local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
	foreach my $t (@phpwiki_tables) {
		local $clash = &find_database_table($dbtype, $dbname, $t);
		$clash && return "Php-Wiki appears to be already using the selected database (table $clash)";
		}
	}
return undef;
}

# script_phpwiki_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by PHP-Nuke, each of which is a hash ref
# containing a name, filename and URL
sub script_phpwiki_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local $ext = $ver >= 1.3 ? "bz2" : "gz";
local @files = ( { 'name' => "source",
	   'file' => "phpwiki-$ver.tar.$ext",
	   'url' => "http://osdn.dl.sourceforge.net/sourceforge/phpwiki/phpwiki-$ver.tar.$ext" } );
return @files;
}

sub script_phpwiki_commands
{
local ($d, $ver) = @_;
return ("tar", $ver >= 1.3 ? "bunzip2" : "gunzip");
}

# script_phpwiki_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs PhpWiki, and returns either 1 and an informational
# message, or 0 and an error
sub script_phpwiki_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;

if ($opts->{'db'} && $opts->{'newdb'} && !$upgrade) {
	local $err = &create_script_database($d, $opts->{'db'});
	return (0, "Database creation failed : $err") if ($err);
	}

local ($out, $ex);
local $unzipper = $files->{'source'} =~ /\.gz$/ ? "gunzip" : "bunzip2";
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "pgsql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "phpwiki-$ver");
$err && return (0, "Failed to extract source : $err");
local $cfile = "$opts->{'dir'}/lib/config.php";

local %done;
local $pages = "$opts->{'dir'}/pages";
if ($ver < 1.3) {
	# Older versions have settings in config.php
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	if ($opts->{'db'}) {
		# Set database details in config.php
		local $l;
		foreach $l (@$lref) {
			if ($l =~ /^\s*\$WhichDatabase\s*=/ &&
			    !$done{'WhichDatabase'}++) {
				$l = "\$WhichDatabase = '$dbphptype';"
				}
			if ($dbtype eq "mysql") {
				if ($l =~ /^\s*\$mysql_user\s*=/ &&
				    !$done{'mysql_user'}++) {
					$l = "\$mysql_user = '$dbuser';"
					}
				if ($l =~ /^\s*\$mysql_pwd\s*=/ &&
				    !$done{'mysql_pwd'}++) {
					$l = "\$mysql_pwd = '".
					     &php_quotemeta($dbpass)."';"
					}
				if ($l =~ /^\s*\$mysql_db\s*=/ &&
				    !$done{'mysql_db'}++) {
					$l = "\$mysql_db = '$dbname';"
					}
				if ($l =~ /^\s*\$mysql_host\s*=/ &&
				    !$done{'mysql_host'}++) {
					$l = "\$mysql_host = '$dbhost';"
					}
				}
			if ($dbtype eq "postgres") {
				if ($l =~ /^\s*\$pg_dbuser\s*=/ &&
				    !$done{'pg_dbuser'}++) {
					$l = "\$pg_dbuser = '$dbuser';"
					}
				if ($l =~ /^\s*\$pg_dbpass\s*=/ &&
				    !$done{'pg_dbpass'}++) {
					$l = "\$pg_dbpass = '".
					     &php_quotemeta($dbpass)."';"
					}
				if ($l =~ /^\s*\$pg_dbhost\s*=/ &&
				    !$done{'pg_dbhost'}++) {
					$l = "\$pg_dbhost = '$dbhost';"
					}
				if ($l =~ /^\s*\$WikiDataBase\s*=/ &&
				    !$done{'WikiDataBase'}++) {
					$l = "\$WikiDataBase = '$dbname';"
					}
				}
			}
		}
	else {
		# Set data directory in config.php
		local $l;
		foreach $l (@$lref) {
			if ($l =~ /^\s*\$DBMdir\s*=/ &&
			    !$done{'DBMdir'}++) {
				$l = "\$DBMdir = '$pages';"
				}
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);
	}
else {
	# Versions 1.3 and above use a config.ini file
	local $inifile = "$opts->{'dir'}/config/config.ini";
	if (!-r $inifile) {
		&run_as_domain_user($d, "cp ".
			quotemeta("$opts->{'dir'}/config/config-dist.ini").
			" ".quotemeta($inifile));
		}
	local $lref = &read_file_lines_as_domain_user($d, $inifile);
	local $l;
	if ($opts->{'db'}) {
		# Update database setting in config.ini
		local $dsn = "$dbphptype://$dbuser:".
			     &php_quotemeta($dbpass)."\@$dbhost/$dbname";
		foreach $l (@$lref) {
			if ($l =~ /^\s*DATABASE_DSN\s*=/) {
				$l = "DATABASE_DSN = $dsn";
				}
			elsif ($l =~ /^\s*DATABASE_TYPE\s*=/) {
				$l = "DATABASE_TYPE = SQL";
				}
			}
		}
	else {
		# Just set data directory in config.ini
		foreach $l (@$lref) {
			if ($l =~ /^\s*DATABASE_DIRECTORY\s*=/) {
				$l = "DATABASE_DIRECTORY = $pages";
				}
			}
		}
	# Update common settings in config.ini
	foreach $l (@$lref) {
		if ($l =~ /^;?\s*ADMIN_USER\s*=/) {
			$l = "ADMIN_USER = $domuser";
			}
		if ($l =~ /^;?\s*ADMIN_PASSWD\s*=/) {
			$l = "ADMIN_PASSWD = $dompass";
			}
		if ($l =~ /^;?\s*USE_PATH_INFO\s*=/) {
			$l = "USE_PATH_INFO = true";
			}
		if ($l =~ /^;?\s*VIRTUAL_PATH\s*=/) {
			$l = "VIRTUAL_PATH = $opts->{'path'}";
			}
		if ($l =~ /^;?\s*SCRIPT_NAME\s*=/) {
			$l = "SCRIPT_NAME = $opts->{'path'}/index.php";
			}
		}
	&flush_file_lines_as_domain_user($d, $inifile);
	}

if (!$upgrade && $opts->{'db'}) {
	# Run the SQL setup script
	if ($dbtype eq "mysql") {
		local $sqlfile = $ver >= 1.3 ?
			"$opts->{'dir'}/schemas/mysql-initialize.sql" :
			"$opts->{'dir'}/schemas/schema.mysql";
		&require_mysql();
		($ex, $out) = &mysql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
		$ex && return (0, "Failed to run database setup script : <tt>$out</tt>.");
		}
	elsif ($dbtype eq "postgres") {
		local $sqlfile = $ver >= 1.3 ?
			"$opts->{'dir'}/schemas/psql-initialize.sql" :
			"$opts->{'dir'}/schemas/schema.psql";
		&require_postgres();
		($ex, $out) = &postgresql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
		$ex && return (0, "Failed to run database setup script in $dbname : <tt>$out</tt>.");
		}
	}
elsif (!$opts->{'db'}) {
	# Create the pages directory
	if (!-d $pages) {
		&make_dir_as_domain_user($d, $pages, 0777);
		&make_file_php_writable($d, $pages);
		}
	}

if (!$upgrade) {
	# Make the themes directory world-readable
	&run_as_domain_user($d, "chmod -R 755 ".
				quotemeta("$opts->{'dir'}/themes"));
	}

local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Php-Wiki installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.", $opts->{'db'} ? "Under $rp using $dbphptype database $dbname" : "Under $rp", $url, $domuser, $dompass);
}

# script_phpwiki_uninstall(&domain, version, &opts)
# Un-installs a PHP-Nuke installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_phpwiki_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all phpWiki tables from the database
if ($opts->{'db'}) {
	&cleanup_script_database($d, $opts->{'db'}, \@phpwiki_tables);
	}

# Take out the DB
if ($opts->{'newdb'} && $opts->{'db'}) {
	&delete_script_database($d, $opts->{'db'});
	}

return (1, $opts->{'db'} ? "phpWiki directory and tables deleted."
		         : "phpWiki directory deleted.");
}

# script_phpwiki_check_latest(version)
# Checks if some version is the latest for this project, and if not returns
# a newer one. Otherwise returns undef.
sub script_phpwiki_check_latest
{
local ($ver) = @_;
local @vers = &osdn_package_versions("phpwiki",
			"phpwiki-([0-9\\.]+)\\.tar\\.gz",
			"phpwiki-([0-9rc\\.]+)\\.tar\\.bz2");
if (&compare_versions($ver, 1.4) > 0) {
	@vers = grep { &compare_versions($_, 1.4) > 0 } @vers;
	}
elsif (&compare_versions($ver, 1.3) > 0) {
	@vers = grep { &compare_versions($_, 1.3) > 0 &&
		       &compare_versions($_, 1.4) < 0 } @vers;
	}
else {
	@vers = grep { &compare_versions($_, 1.3) < 0 } @vers;
	}
return "Failed to find versions" if (!@vers);
return $ver eq $vers[0] ? undef : $vers[0];
}

sub script_phpwiki_site
{
return 'http://phpwiki.sourceforge.net/';
}

sub script_phpwiki_passmode
{
return 1;
}

1;

