
# script_plans_desc()
sub script_plans_desc
{
return "Plans";
}

sub script_plans_uses
{
return ( "perl", "cgi", "apache" );
}

sub script_plans_longdesc
{
return "Plans lets you put calendars on the web.";
}

# script_plans_versions()
sub script_plans_versions
{
return ( "8.2.1" );
}

sub script_plans_category
{
return "Calendar";
}

sub script_plans_perl_modules
{
return ( "CGI::Session", "CGI" );
}

# script_plans_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_plans_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("plans", $d), 30, "At top level"));
	}
return $rv;
}

# script_plans_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_plans_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	return { 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_plans_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_plans_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/plans.cgi") {
	return "Plans appears to be already installed in the selected directory";
	}
return undef;
}

# script_plans_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Twiki, each of which is a hash ref
# containing a name, filename and URL
sub script_plans_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "plans_$ver.zip",
	   'url' => "http://www.planscalendar.com/release/plans_$ver.zip" } );
return @files;
}

sub script_plans_commands
{
return ("unzip");
}

# script_plans_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs PhpWiki, and returns either 1 and an informational
# message, or 0 and an error
sub script_plans_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);

# Preserve old config file
local $cfile = "$opts->{'dir'}/plans_config.pl";
local $oldcfile = &transname();
if ($upgrade) {
	&copy_source_dest($cfile, $oldcfile);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "plans_$ver");
$err && return (0, "Failed to extract source : $err");

local $url = &script_path_url($d, $opts);
if ($upgrade) {
	# Put back original config file
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	}
else {
	# Edit the config file
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	foreach my $l (@$lref) {
		if ($l =~ /^#*\s*\$options{calendar_url}\s*=/) {
			$l = "\$options{calendar_url} = '$url';\n";
			}
		if ($l =~ /^#*\s*\$options{default_theme_path}\s*=/) {
			$l = "\$options{default_theme_path} = '$opts->{'dir'}/theme';\n";
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);

	# Edit the config containing the password
	local $lfile = "$opts->{'dir'}/plans_lib.pl";
	local $lref = &read_file_lines_as_domain_user($d, $lfile);
	foreach my $l (@$lref) {
		if ($l =~ /crypt\("12345"/) {
			$l =~ s/12345/$dompass/g;
			}
		if ($l =~ /this\s+calendar\s+is\s+"12345"/) {
			$l =~ s/"12345"/the domain's password/g;
			}
		}
	&flush_file_lines_as_domain_user($d, $lfile);

	# Edit the XML file containing the password
	local $xfile = "$opts->{'dir'}/data/calendars.xml";
	local $data = &read_file_contents_as_domain_user($d, $xfile);
	local $crypt = crypt($dompass, "NaCl");
	$data =~ s/<admin_password>([^<]+)<\/admin_password>/<admin_password>$crypt<\/admin_password>/g;
	$data =~ s/this\s+calendar\s+is\s+"12345"/this calendar is the domain's password/g;
	&open_tempfile_as_domain_user($d, XFILE, ">$xfile");
	&print_tempfile(XFILE, $data);
	&close_tempfile_as_domain_user($d, XFILE);
	}

# Make the data directory writable
&make_file_php_writable($d, "$opts->{'dir'}/data");

# Make CGIs mode 755 for suexec
$out = &run_as_domain_user($d, "chmod 755 ".quotemeta($opts->{'dir'})."/*.cgi");

# Enable CGIs for the directory
&require_apache();
local @ports;
push(@ports, $d->{'web_port'}) if ($d->{'web'});
push(@ports, $d->{'web_sslport'}) if ($d->{'ssl'});
foreach my $port (@ports) {
	local ($virt, $vconf) = &get_apache_virtual($d->{'dom'}, $port);
	next if (!$virt);
	local @dirs = grep { $_ eq $opts->{'dir'} } 
			   &apache::find_directive("Directory", $vconf);
	if (!@dirs) {
		local $lref = &read_file_lines($virt->{'file'});
		splice(@$lref, $virt->{'eline'}, 0,
		       "<Directory $opts->{'dir'}>",
		       "Options ExecCGI",
		       "DirectoryIndex plans.cgi",
		       "AddHandler cgi-script .cgi",
		       "</Directory>");
		&flush_file_lines($virt->{'file'});
		undef(@apache::get_config_cache);
		}
	}
&register_post_action(\&restart_apache);

local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Plans installation complete. Go to <a target=_blank href='$url'>$url</a> to use it.", "Under $rp", $url, undef, $dompass);
}

# script_plans_uninstall(&domain, version, &opts)
# Un-installs a Twiki installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_plans_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove Apache config entry for /plans
&require_apache();
local @ports;
push(@ports, $d->{'web_port'}) if ($d->{'web'});
push(@ports, $d->{'web_sslport'}) if ($d->{'ssl'});
foreach my $port (@ports) {
	local ($virt, $vconf) = &get_apache_virtual($d->{'dom'}, $port);
	next if (!$virt);
	local ($dir) = grep { $_->{'words'}->[0] eq $opts->{'dir'} } 
			    &apache::find_directive_struct("Directory", $vconf);
	if ($dir) {
		local $lref = &read_file_lines($dir->{'file'});
		splice(@$lref, $dir->{'line'},
		       $dir->{'eline'} - $dir->{'line'} + 1);
		&flush_file_lines($dir->{'file'});
		undef(@apache::get_config_cache);
		}
	}
&register_post_action(\&restart_apache);

return (1, "Plans directory deleted.");
}

# script_plans_latest(version)
# Returns a URL and regular expression or callback func to get the version
sub script_plans_latest
{
local ($ver) = @_;
return ( "http://www.planscalendar.com/index.php?p=download",
	 "plans_([0-9\\.]+).zip" );
}

sub script_plans_site
{
return 'http://www.planscalendar.com/';
}

sub script_plans_passmode
{
return 2;
}

1;

