
# script_vacation_desc()
sub script_vacation_desc
{
return "Vacation";
}

sub script_vacation_uses
{
return ( "php", "horde" );
}

sub script_vacation_longdesc
{
return "Vacation is a Horde module for managing user e-mail vacation notices or auto-responders."
}

# script_vacation_versions()
sub script_vacation_versions
{
return ( "h3-3.2.1" );
}

sub script_vacation_category
{
return "Horde";
}

# script_vacation_depends(&domain, version)
sub script_vacation_depends
{
local ($d, $ver) = @_;

# Check for horde install
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
return ("Vacation requires that Horde be installed first") if (!$horde);

return @rv;
}

# script_vacation_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_vacation_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
        local $odir = $horde->{'opts'}->{'dir'};
        $odir =~ s/^\Q$d->{'home'}\E\///;
	$rv .= &ui_table_row("Install sub-directory under <tt>$odir</tt>",
			     &ui_textbox("dir", "vacation", 30));
	}
return $rv;
}

# script_vacation_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_vacation_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local @scripts = &list_domain_scripts($d);
	local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
	$in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = "$horde->{'opts'}->{'dir'}/$in{'dir'}";
	$dir =~ s/\/\//\//g;
        local $path = "$horde->{'opts'}->{'path'}/$in{'dir'}";
        $path =~ s/\/\//\//g;
	return { 'dir' => $dir,
		 'path' => $path,
		 'db' => $horde->{'opts'}->{'db'},
		 'horde' => 1 };
	}
}

# script_vacation_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_vacation_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/index.php") {
	return "Vacation appears to be already installed in the selected directory";
	}
return undef;
}

# script_vacation_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Vacation, each of which is a hash ref
# containing a name, filename and URL
sub script_vacation_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "vacation-$ver.tar.gz",
	   'url' => "ftp://ftp.horde.org/pub/vacation/vacation-$ver.tar.gz" } );
return @files;
}

sub script_vacation_commands
{
return ("tar", "gunzip");
}

# script_vacation_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Vacation, and returns either 1 and an informational
# message, or 0 and an error
sub script_vacation_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "vacation-$ver");
$err && return (0, "Failed to extract source : $err");

# Copy the config files
local $cdir = "$opts->{'dir'}/config";
opendir(DIR, $cdir);
foreach my $f (readdir(DIR)) {
	if ($f =~ /^(.*)\.dist$/ && !-r "$cdir/$1") {
		&run_as_domain_user($d, "cp ".quotemeta("$cdir/$f")." ".
					      quotemeta("$cdir/$1"));
		&make_file_php_writable($d, "$cdir/$1");
		}
	}
closedir(DIR);
&make_file_php_writable($d, $cdir);

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Vacation installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>. However, it must first be configured using Horde at <a target=_blank href='$horde->{'url'}'>$horde->{'url'}</a>, on the Setup page under Administration.", "Under $rp", $url);
}

# script_vacation_uninstall(&domain, version, &opts)
# Un-installs a Vacation installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_vacation_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

return (1, "Vacation directory deleted.");
}

# script_vacation_latest()
# Returns a URL and regular expression or callback func to get the version
sub script_vacation_latest
{
return ( "http://ftp.horde.org/pub/vacation/",
         "vacation-(h3-[0-9\\.]+)\\.tar\\.gz" );
}

sub script_vacation_site
{
return 'http://www.horde.org/vacation/';
}

1;

