
# script_xoops_desc()
sub script_xoops_desc
{
return "Xoops";
}

sub script_xoops_uses
{
return ( "php" );
}

sub script_xoops_longdesc
{
return "XOOPS is an extensible, OO, easy to use dynamic web content management system written in PHP.";
}

# script_xoops_versions()
sub script_xoops_versions
{
return ( "2.0.18.2" );
}

sub script_xoops_category
{
return "Content Management System";
}

sub script_xoops_php_vers
{
return ( 4, 5 );
}

sub script_xoops_php_modules
{
return ("mysql");
}

sub script_xoops_dbs
{
return ("mysql");
}

# script_xoops_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_xoops_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	if ($dbtype) {
		$rv .= &ui_table_row("Database for Xoops tables", $dbname);
		}
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for Xoops tables",
		     &ui_database_select("db", undef, \@dbs, $d, "xoops"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("xoops", $d), 30, "At top level"));
	}
return $rv;
}

# script_xoops_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_xoops_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
                 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_xoops_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_xoops_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/admin.php") {
	return "Xoops appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "xoops_.*");
$clash && return "Xoops appears to be already using the selected database (table $clash)";
return undef;
}

# script_xoops_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_xoops_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "xoops-$ver.tar.gz",
	   'url' => "http://osdn.dl.sourceforge.net/sourceforge/xoops/xoops-$ver.tar.gz" } );
return @files;
}

sub script_xoops_commands
{
return ("tar", "gunzip");
}

# script_xoops_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Xoops, and returns either 1 and an informational
# message, or 0 and an error
sub script_xoops_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);

# Get and test DB connection. We may not have this if upgrading from an older
# installer though.
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
if ($dbname) {
	local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
	return (0, "Database connection failed : $dberr") if ($dberr);
	}

# Preserve old config file
local $cfile = "$opts->{'dir'}/mainfile.php";
local $srccfile = "$opts->{'dir'}/mainfile.dist.php";
local $oldcfile = &transname();
if ($upgrade) {
	&copy_source_dest($cfle, $oldcfile);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "xoops-*/htdocs");
$err && return (0, "Failed to extract source : $err");

# Set file permissions
&make_file_php_writable($d, "$opts->{'dir'}/mainfile.php");
&make_file_php_writable($d, "$opts->{'dir'}/uploads", 1);
&make_file_php_writable($d, "$opts->{'dir'}/cache", 1);
&make_file_php_writable($d, "$opts->{'dir'}/templates_c", 1);

local $url = &script_path_url($d, $opts);
local $urlnoslash = $url;
$urlnoslash =~ s/\/$//;
if ($upgrade) {
	# Put back old config file
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	}
elsif ($ver >= 2.3) {
	# Edit main configuration file
	&copy_source_dest_as_domain_user($d, $srccfile, $cfile);
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	foreach my $l (@$lref) {
		if ($l =~ /^\s*define\("XOOPS_ROOT_PATH"/) {
			$l = "define(\"XOOPS_ROOT_PATH\", \"$opts->{'dir'}\");\n";
			}
		if ($l =~ /^\s*define\("XOOPS_PATH"/) {
			$l = "define(\"XOOPS_PATH\", \"$opts->{'dir'}/xoops_lib\");\n";
			}
		if ($l =~ /^\s*define\("XOOPS_VAR_PATH"/) {
			$l = "define(\"XOOPS_VAR_PATH\", \"$opts->{'dir'}/xoops_data\");\n";
			}
		if ($l =~ /^\s*define\("XOOPS_URL"/) {
			$l = "define(\"XOOPS_URL\", \"$urlnoslash\");\n";
			}
		if ($l =~ /^\s*define\("XOOPS_DB_TYPE"/) {
			$l = "define(\"XOOPS_DB_TYPE\", \"mysql\");\n";
			}
		if ($l =~ /^\s*define\("XOOPS_DB_PREFIX"/) {
			$l = "define(\"XOOPS_DB_PREFIX\", \"xoops\");\n";
			}
		if ($l =~ /^\s*define\("XOOPS_DB_HOST"/) {
			$l = "define(\"XOOPS_DB_HOST\", \"$dbhost\");\n";
			}
		if ($l =~ /^\s*define\("XOOPS_DB_USER"/) {
			$l = "define(\"XOOPS_DB_USER\", \"$dbuser\");\n";
			}
		if ($l =~ /^\s*define\("XOOPS_DB_PASS"/) {
			$l = "define(\"XOOPS_DB_PASS\", \"".
			     &php_quotemeta($dbpass)."\");\n";
			}
		if ($l =~ /^\s*define\("XOOPS_DB_NAME"/) {
			$l = "define(\"XOOPS_DB_NAME\", \"$dbname\");\n";
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);

	# Call table creation URL
	local ($iout, $ierror);
	local $ipage = $opts->{'path'}."/install/page_tablescreate.php";
	&post_http_connection($d, $ipage, undef, \$iout, \$ierror);
	if ($ierror && $ierror !~ /303/) {
		return (-1, "Xoops database creation failed : $ierror");
		}

	# Make username params
	local @params = (
		[ "adminname", $domuser ],
		[ "adminmail", $d->{'emailto_addr'} ],
		[ "adminpass", $dompass ],
		[ "adminpass2", $dompass ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);

	# Call data init URL
	local ($iout, $ierror);
	local $ipage = $opts->{'path'}."/install/page_siteinit.php";
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror && $ierror !~ /303/) {
		return (-1, "Xoops database creation failed : $ierror");
		}
	}
else {
	# Call install wizard URLs
	local @params = (
		[ "database", "mysql" ],
		[ "dbhost", $dbhost ],
		[ "dbuname", $dbuser ],
		[ "dbpass", $dbpass ],
		[ "dbname", $dbname ],
		[ "prefix", "xoops" ],
		[ "db_pconnect", 0 ],
		[ "root_path", $opts->{'dir'} ],
		[ "xoops_url", $urlnoslash ],
		[ "submit", "Next" ],
		[ "op", "dbconfirm" ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install/index.php";

	# Make an HTTP post to the DB setup page
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror =~ /303/) {
		# Redirect .. that's OK
		}
	elsif ($ierror) {
		return (-1, "Xoops database configuration failed : $ierror");
		}
	elsif ($iout !~ /Please\s+confirm/i) {
		return (-1, "Xoops database configuration failed");
		}

	# Make another post to the config save page
	$params[$#params]->[1] = "dbsave";
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror =~ /303/) {
		# Redirect .. that's OK
		}
	elsif ($ierror) {
		return (-1, "Xoops post-install configuration failed : $ierror");
		}
	elsif ($iout !~ /Saving\s+configuration/i) {
		return (-1, "Xoops post-install configuration failed");
		}

	# Make a post to create DB tables
	@params = (
		[ "submit", "Next" ],
		[ "op", "createTables" ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror =~ /303/) {
		# Redirect .. that's OK
		}
	elsif ($ierror) {
		return (-1, "Xoops database creation failed : $ierror");
		}
	elsif ($iout !~ /Database\s+tables\s+created/i) {
		return (-1, "Xoops database creation failed");
		}

	# Make a post to create the admin user
	@params = (
		[ "adminname", $domuser ],
		[ "adminmail", $d->{'emailto_addr'} ],
		[ "adminpass", $dompass ],
		[ "adminpass2", $dompass ],
		[ "submit", "Next" ],
		[ "op", "insertData" ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror =~ /303/) {
		# Redirect .. that's OK
		}
	elsif ($ierror) {
		return (-1, "Xoops user creation failed : $ierror");
		}
	elsif ($iout !~ /insert\s+data/i) {
		return (-1, "Xoops user creation failed");
		}

	# Delete the install directory, and make config file non-writable
	&run_as_domain_user($d, "rm -rf ".quotemeta("$opts->{'dir'}/install"));
	&set_permissions_as_domain_user($d, 0444, $cfile);
	}

# Return a URL for the user
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Xoops installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.", "Under $rp using $dbtype database $dbname", $url, $domuser, $dompass);
}

# script_xoops_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_xoops_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

if ($opts->{'db'}) {
	# Remove all xoops_ tables from the database, if we have one
	&cleanup_script_database($d, $opts->{'db'}, "xoops_");

	# Take out the DB
	if ($opts->{'newdb'}) {
		&delete_script_database($d, $opts->{'db'});
		}
	return (1, "Xoops directory and database deleted.");
	}
else {
	return (1, "Xoops directory deleted. Database tables must be removed manually.");
	}
}

# script_xoops_latest(version)
# Returns a URL and regular expression or callback func to get the version
#sub script_xoops_latest
#{
#local ($ver) = @_;
#return ( "http://www.xoops.org/modules/core/",
#	 "XOOPS\\s+(2\\.[0]\\.[0-9\\.]+)" );
#}

sub script_xoops_site
{
return 'http://www.xoops.org/';
}

sub script_xoops_passmode
{
return 1;
}

1;

