
@zikula_tables = (
    "admin_category",
    "admin_module",
    "block_placements",
    "block_positions",
    "blocks",
    "categories_category",
    "categories_mapmeta",
    "categories_mapobj",
    "categories_registry",
    "group_applications",
    "group_membership",
    "group_perms",
    "groups",
    "hook_area",
    "hook_binding",
    "hook_provider",
    "hook_runtime",
    "hook_subscriber",
    "hooks",
    "module_deps",
    "module_vars",
    "modules",
    "objectdata_attributes",
    "objectdata_log",
    "objectdata_meta",
    "sc_intrusion",
    "search_result",
    "search_stat",
    "session_info",
    "themes",
    "userblocks",
    "users",
    "users_verifychg",
    "workflows",
    );

# script_zikula_desc()
sub script_zikula_desc
{
return "Zikula";
}

sub script_zikula_uses
{
return ( "php" );
}

sub script_zikula_longdesc
{
return "Zikula is software that creates an impressive, dynamic web site and provides you with a site you can administer with a minimal amount of HTML knowledge.";
}

# script_zikula_versions()
sub script_zikula_versions
{
return ( "1.3.7" );
}

sub script_zikula_category
{
return "Content Management System";
}

sub script_zikula_php_vers
{
local ($d, $ver) = @_;
return ( 5 );
}

sub script_zikula_php_modules
{
return ("mysql");
}

sub script_zikula_perl_modules
{
return ( "Digest::MD5" );
}

sub script_zikula_dbs
{
return ("mysql", "postgres");
}

# script_zikula_depends(&domain, version)
sub script_zikula_depends
{
local ($d, $ver, $sinfo, $phpver) = @_;
local @rv;

# Check for PHP 5.3+
local $phpv = &get_php_version($phpver || 5, $d);
if (!$phpv) {
	push(@rv, "Could not work out exact PHP version");
	}
elsif (&compare_versions($phpv, "5.3.2") < 0) {
	push(@rv, "Zikula requires PHP version 5.3.2 or later");
	}

return @rv;
}

# script_zikula_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Zikula
sub script_zikula_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for Zikula tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql", "postgres" ]);
	$rv .= &ui_table_row("Database for Zikula tables",
		     &ui_database_select("db", undef, \@dbs, $d, "zikula"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("zikula", $d), 30, "At top level"));
	}
return $rv;
}

# script_zikula_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_zikula_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_zikula_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_zikula_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/config/config.php") {
	return "Zikula appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "zk_");
$clash && return "Zikula appears to be already using the selected database (table $clash)";
return undef;
}

# script_zikula_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Zikula, each of which is a hash ref
# containing a name, filename and URL
sub script_zikula_files
{
local ($d, $ver, $opts, $upgrade) = @_;
my $shortver = $ver;
$shortver =~ s/\.//g;
local @files = ( { 'name' => "source",
	   'file' => "Zikula_Core-$ver.zip",
	   'method' => "GET",
	   'url' => "http://go.zikula.org/download$shortver" } );
return @files;
}

sub script_zikula_commands
{
return ("unzip");
}

# script_zikula_install(&domain, version, &opts, &files, &upgrade-info,
#			username, password)
# Actually installs Zikula, and returns either 1 and an informational
# message, or 0 and an error
sub script_zikula_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;

# Get DB details
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
	local $err = &create_script_database($d, $opts->{'db'});
	return (0, "Database creation failed : $err") if ($err);
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "psql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $oldcfile = &transname();
local $cfile = "$opts->{'dir'}/config/config.php";
if (-r $cfile) {
	&copy_source_dest($cfile, $oldcfile);
	}
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
				     $opts->{'dir'}, "Zikula_Core-$ver");
$err && return (0, "Failed to extract source : $err");

local $url = &script_path_url($d, $opts);
if ($upgrade) {
	# Just put config file back
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	}
else {
	# Update the config file
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	foreach my $l (@$lref) {
		if ($l =~ /^(\$ZConfig\['DBInfo'\]\['databases'\]\['default'\])\['(\S+)'\]\s/){
			local ($s, $n) = ($1, $2);
			local $v = $n eq "dbdriver" ? $dbtype :
				   $n eq "host" ? $dbhost :
				   $n eq "user" ? $dbuser :
				   $n eq "password" ? &php_quotemeta($dbpass) :
				   $n eq "dbname" ? $dbname : undef;
			if (defined($v)) {
				$l = $s."['".$n."'] = '".$v."';";
				}
			elsif ($n eq "encoded") {
				# Just a number
				$l = $s."['".$n."'] = 0;";
				}
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);
	}

# Make the pnTemp directory writable
&make_file_php_writable($d, "$opts->{'dir'}/pnTemp", 1);

# Fix the .htaccess file if needed, since mod_php directives may not work
local $p = &domain_has_website($d);
if ($p eq 'web' &&
    !$apache::httpd_modules{'mod_php4'} &&
    !$apache::httpd_modules{'mod_php5'}) {
	my $htfile = "$opts->{'dir'}/.htaccess";
	my $lref = &read_file_lines_as_domain_user($d, $htfile);
	foreach my $l (@$lref) {
		if ($l =~ /^\s*php_/) {
			$l = "# $l";
			}
		}
	&flush_file_lines_as_domain_user($d, $htfile);
	}

# Return a URL for the user
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Initial Zikula installation complete. Got to <a href=$url target=_blank>$url</a> to complete the installation process",
	"Under $rp using $dbphptype database $dbname", $url);
}

# script_zikula_uninstall(&domain, version, &opts)
# Un-installs a Zikula installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_zikula_uninstall
{
local ($d, $version, $opts) = @_;

# Remove zk_ tables from the database
if (&compare_versions($version, "1.3.6") >= 0) {
	&cleanup_script_database($d, $opts->{'db'}, \@zikula_tables);
	}
else {
	&cleanup_script_database($d, $opts->{'db'}, "(zk_|z_)");
	}

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Take out the DB
if ($opts->{'newdb'}) {
	&delete_script_database($d, $opts->{'db'});
	}

return (1, "Zikula directory and tables deleted.");
}

# script_zikula_latest(version)
# Returns a URL and regular expression or callback func to get the version
sub script_zikula_latest
{
local ($ver) = @_;
return ( "http://community.zikula.org/",
	 "Get\\s+Zikula\\s+([0-9\\.]+)" );
}

sub script_zikula_site
{
return 'http://zikula.org/';
}

sub script_zikula_passmode
{
return 0;
}

1;

